/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ShellHandler
extends ControlHandler {
    private static final Logger log = Logger.getLogger(ShellHandler.class);
    private static ShellHandler instance;

    public static ShellHandler getInstance() {
        if (instance == null) {
            instance = new ShellHandler();
        }
        return instance;
    }

    public void closeShell(final Shell swtShell) {
        if (!this.isDisposed((Widget)swtShell)) {
            log.info("Closing shell '" + this.getText(swtShell) + "'");
        }
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (swtShell != null && !swtShell.isDisposed()) {
                    swtShell.close();
                }
            }
        });
    }

    public void setFocus(final Shell shell) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    shell.forceActive();
                    boolean isFocus = shell.forceFocus();
                    if (!isFocus) {
                        log.warn("Shell is not focused");
                    }
                }
                catch (SWTException e) {
                    throw new CoreLayerException("Exception thrown during forcing focus", e);
                }
            }
        });
    }

    public void maximize(final Shell swtShell) {
        log.info("Maximize shell '" + this.getText(swtShell) + "'");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtShell.setMaximized(true);
            }
        });
    }

    public void minimize(final Shell swtShell) {
        log.info("Minimize shell '" + this.getText(swtShell) + "'");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtShell.setMinimized(true);
            }
        });
    }

    public void restore(final Shell swtShell) {
        log.info("Restore shell '" + this.getText(swtShell) + "'");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtShell.setMaximized(false);
                swtShell.setMinimized(false);
            }
        });
    }

    public boolean isMaximized(final Shell swtShell) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtShell.getMaximized();
            }
        });
    }

    public boolean isMinimized(final Shell swtShell) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtShell.getMinimized();
            }
        });
    }

    public String getText(final Shell shell) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return shell.getText();
            }
        });
    }

    public Shell[] getShells(final Shell shell) {
        return (Shell[])Display.syncExec((ResultRunnable)new ResultRunnable<Shell[]>(){

            public Shell[] run() {
                return shell.getShells();
            }
        });
    }

    public List<Shell> getAllAncestorShells(Shell shell) {
        ArrayList<Shell> allParentShells = new ArrayList<Shell>();
        Composite parent = this.getParent((Control)shell);
        while (parent != null) {
            allParentShells.add(this.getShell((Control)parent));
            parent = this.getParent((Control)parent);
        }
        return allParentShells;
    }

    public Menu getMenuBar(final Shell shell) {
        log.info("Getting Menu Bar of shell '" + this.getText(shell) + "'");
        return (Menu)Display.syncExec((ResultRunnable)new ResultRunnable<Menu>(){

            public Menu run() {
                return shell.getMenuBar();
            }
        });
    }
}

