/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestSuite;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.TestSuite;
import org.eclipse.rcptt.core.scenario.TestSuiteItem;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.AbstractDeleteTestReferenceChange;
import org.eclipse.rcptt.ui.refactoring.delete.UndoDeleteTestReferenceChange;

public class DeleteTestReferenceChange
extends AbstractDeleteTestReferenceChange {
    protected DeleteTestReferenceChange(ITestSuite testSuite, IQ7NamedElement q7Element) {
        super(testSuite, q7Element);
    }

    public String getName() {
        return Messages.bind((String)Messages.DeleteContextReferenceChange_Name, (Object)this.getQ7Element().getName(), (Object)this.getTestSuite().getName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (!this.isValid()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.DeleteReferenceChange_InvalidRefMsg);
        }
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            ITestSuite suiteCopy = (ITestSuite)this.getTestSuite().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            List<TestSuiteItem> references = this.getReferences(suiteCopy);
            HashMap<Integer, TestSuiteItem> deletedItems = new HashMap<Integer, TestSuiteItem>();
            for (TestSuiteItem item : references) {
                int idx = suiteCopy.getTestSuite().getItems().indexOf((Object)item);
                deletedItems.put(idx, item);
            }
            try {
                TestSuite suiteNamedElement = (TestSuite)suiteCopy.getModifiedNamedElement();
                for (TestSuiteItem item : references) {
                    suiteNamedElement.getItems().remove((Object)item);
                }
                suiteCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                suiteCopy.discardWorkingCopy();
            }
            UndoDeleteTestReferenceChange undoDeleteTestReferenceChange = new UndoDeleteTestReferenceChange(this.getTestSuite(), this.getQ7Element(), deletedItems);
            return undoDeleteTestReferenceChange;
        }
        finally {
            pm.done();
        }
    }

    private List<TestSuiteItem> getReferences(ITestSuite suite) throws ModelException {
        ArrayList<TestSuiteItem> result = new ArrayList<TestSuiteItem>();
        for (TestSuiteItem item : suite.getTestSuite().getItems()) {
            if (!this.getQ7Element().getID().equals(item.getNamedElementId())) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    protected boolean isValid() throws ModelException {
        if (!super.isValid()) {
            return false;
        }
        return this.getReferences(this.getTestSuite()).size() > 0;
    }
}

