/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.xtext.build.analysis.IdiomMatch;
import org.eclipse.ocl.examples.xtext.build.analysis.SerializationRuleAnalysis;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.idioms.Idiom;
import org.eclipse.ocl.examples.xtext.idioms.IdiomsUtils;
import org.eclipse.ocl.examples.xtext.idioms.SubIdiom;
import org.eclipse.ocl.examples.xtext.serializer.SerializationUtils;

public class IdiomSerializationMatch
implements IdiomMatch {
    protected final @NonNull Idiom idiom;
    private int subIdiomIndex = 0;
    private final @NonNull SerializationNode @NonNull [] locatedNodes;
    private @Nullable IdiomSerializationMatch nestedMatch = null;
    private @Nullable IdiomSerializationMatch additionalMatch = null;

    public IdiomSerializationMatch(@NonNull Idiom idiom, @NonNull SerializationNode serializationNode) {
        this.idiom = idiom;
        this.locatedNodes = new SerializationNode[idiom.getOwnedSubIdioms().size()];
        this.locatedNodes[this.subIdiomIndex++] = serializationNode;
    }

    public @NonNull Idiom getIdiom() {
        return this.idiom;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean installIn(@NonNull Map<@NonNull SerializationNode, @NonNull List<@NonNull SubIdiom>> serializationNode2subIdioms) {
        if (this.additionalMatch != null) {
            this.additionalMatch.installIn(serializationNode2subIdioms);
        }
        if (this.subIdiomIndex >= this.locatedNodes.length) {
            SerializationNode[] serializationNodeArray = this.locatedNodes;
            int n = this.locatedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull SerializationNode serializationNode = serializationNodeArray[n2];
                @NonNull List subIdioms = (List)SerializationUtils.maybeNull(serializationNode2subIdioms.get(serializationNode));
                if (subIdioms != null && !this.isAllMixIn(subIdioms)) {
                    return false;
                }
                ++n2;
            }
        }
        if (this.nestedMatch != null && !this.nestedMatch.installIn(serializationNode2subIdioms)) {
            return false;
        }
        if (this.subIdiomIndex >= this.locatedNodes.length) {
            int i = 0;
            while (i < this.locatedNodes.length) {
                SerializationNode serializationNode = this.locatedNodes[i];
                SubIdiom subIdiom = (SubIdiom)SerializationUtils.nonNullState((Object)((SubIdiom)IdiomsUtils.getOwnedSubIdioms((Idiom)this.idiom).get(i)));
                if (subIdiom.getOwnedSegments().size() > 0) {
                    ArrayList<@NonNull SubIdiom> subIdioms = (ArrayList<SubIdiom>)SerializationUtils.maybeNull(serializationNode2subIdioms.get(serializationNode));
                    if (subIdioms == null) {
                        subIdioms = new ArrayList<SubIdiom>();
                        serializationNode2subIdioms.put(serializationNode, subIdioms);
                    }
                    if (this.isAllMixIn((Iterable<SubIdiom>)subIdioms)) {
                        subIdioms.add(subIdiom);
                    }
                }
                ++i;
            }
        }
        return true;
    }

    protected boolean isAllMixIn(@NonNull Iterable<@NonNull SubIdiom> subIdioms) {
        for (SubIdiom subIdiom : subIdioms) {
            if (IdiomsUtils.getOwningIdiom((SubIdiom)subIdiom).isMixin()) continue;
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public boolean nextMatch(@NonNull SerializationNode serializationNode, @NonNull SerializationRuleAnalysis serializationRule) {
        @NonNull List subIdioms = IdiomsUtils.getOwnedSubIdioms((Idiom)this.idiom);
        if (this.subIdiomIndex >= this.locatedNodes.length) {
            if (this.additionalMatch != null) {
                this.additionalMatch.nextMatch(serializationNode, serializationRule);
            } else if (serializationRule.matches((SubIdiom)subIdioms.get(0), serializationNode)) {
                this.additionalMatch = new IdiomSerializationMatch(this.idiom, serializationNode);
            }
            return true;
        }
        if (this.nestedMatch != null && this.nestedMatch.nextMatch(serializationNode, serializationRule)) {
            return true;
        }
        if (serializationRule.matches((SubIdiom)subIdioms.get(this.subIdiomIndex), serializationNode)) {
            this.locatedNodes[this.subIdiomIndex++] = serializationNode;
            return true;
        }
        if (serializationRule.matches((SubIdiom)subIdioms.get(0), serializationNode)) {
            this.nestedMatch = new IdiomSerializationMatch(this.idiom, serializationNode);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull StringBuilder s, int depth) {
        if (depth == 0) {
            s.append(this.idiom);
        }
        int i = 0;
        while (i < this.subIdiomIndex) {
            SerializationUtils.appendIndentation((StringBuilder)s, (int)depth);
            s.append(this.locatedNodes[i]);
            ++i;
        }
        if (this.nestedMatch != null) {
            this.nestedMatch.toString(s, depth + 1);
        }
        if (this.additionalMatch != null) {
            this.additionalMatch.toString(s, depth);
        }
    }
}

