/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.launch;

import java.util.AbstractMap;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.linuxtools.internal.gprof.launch.GprofLaunchMessages;
import org.eclipse.linuxtools.profiling.ui.TitleAreaDialogWithRadioButtons;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class GprofNoGmonDialog {
    private String gmonExpected;

    public GprofNoGmonDialog(IProject project, Shell shell) {
        ArrayList<AbstractMap.SimpleEntry<String, String>> buttonList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        buttonList.add(new AbstractMap.SimpleEntry<String, String>("browseWorkSpace", GprofLaunchMessages.GprofNoGmonOut_BrowseWorkSpace));
        buttonList.add(new AbstractMap.SimpleEntry<String, String>("browseFileSystem", GprofLaunchMessages.GprofNoGmonOut_BrowseFileSystem));
        buttonList.add(new AbstractMap.SimpleEntry<String, String>("cancleLaunch", GprofLaunchMessages.GprofNoGmonOut_CancleLaunch));
        String title = GprofLaunchMessages.GprofNoGmonOut_title;
        String body = GprofLaunchMessages.GprofNoGmonOut_body;
        int msgType = 3;
        TitleAreaDialogWithRadioButtons gmonMissingDialog = new TitleAreaDialogWithRadioButtons(shell, title, body, buttonList, msgType);
        int retVal = gmonMissingDialog.open();
        switch (retVal) {
            case 0: {
                switch (gmonMissingDialog.getSelectedButton()) {
                    case "browseWorkSpace": {
                        this.gmonExpected = GprofNoGmonDialog.browseWorkspaceHandler(shell, project);
                        break;
                    }
                    case "browseFileSystem": {
                        this.gmonExpected = GprofNoGmonDialog.browseFileSystemHandler(shell, project);
                        break;
                    }
                    default: {
                        this.gmonExpected = null;
                        return;
                    }
                }
            }
            case 1: {
                return;
            }
        }
    }

    public String getGmonExpected() {
        return this.gmonExpected;
    }

    private static String browseFileSystemHandler(Shell shell, IProject project) {
        FileDialog dialog = new FileDialog(shell != null ? shell : new Shell(), 4096);
        dialog.setText(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
        if (project != null) {
            dialog.setFilterPath(project.getLocation().toOSString());
        }
        return dialog.open();
    }

    private static String browseWorkspaceHandler(Shell shell, IProject project) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
        dialog.setMessage(GprofLaunchMessages.GprofNoGmonDialog_OpenGmon);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(false);
        dialog.setInitialSelection((Object)project);
        dialog.setValidator(selection -> {
            if (selection.length != 1) {
                return new Status(4, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
            }
            if (!(selection[0] instanceof IFile)) {
                return new Status(4, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
            }
            return new Status(0, "org.eclipse.linuxtools.gprof.launch", 0, "", null);
        });
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            return resource.getLocation().toOSString();
        }
        return null;
    }
}

