/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.libra.framework.core.IOSGIFrameworkWorkingCopy;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.libra.framework.ui.Trace;
import org.eclipse.libra.framework.ui.internal.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.IInstallableRuntime;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.wizard.TaskWizard;
import org.eclipse.wst.server.ui.internal.wizard.fragment.LicenseWizardFragment;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class OSGIFrameworkComposite
extends Composite {
    protected IRuntimeWorkingCopy runtimeWC;
    protected IOSGIFrameworkWorkingCopy runtime;
    protected IWizardHandle wizard;
    protected Text installDir;
    protected Text name;
    protected Combo combo;
    protected List installedJREs;
    protected String[] jreNames;
    protected IInstallableRuntime ir;
    protected Job installRuntimeJob;
    protected IJobChangeListener jobListener;
    protected Label installLabel;
    protected Button install;

    protected OSGIFrameworkComposite(Composite parent, IWizardHandle wizard) {
        super(parent, 0);
        this.wizard = wizard;
        wizard.setTitle(Messages.wizardTitle);
        wizard.setDescription(Messages.wizardDescription);
        this.createControl();
    }

    protected void setRuntime(IRuntimeWorkingCopy newRuntime) {
        if (newRuntime == null) {
            this.runtimeWC = null;
            this.runtime = null;
        } else {
            this.runtimeWC = newRuntime;
            this.runtime = (IOSGIFrameworkWorkingCopy)newRuntime.loadAdapter(IOSGIFrameworkWorkingCopy.class, null);
        }
        if (this.runtimeWC == null) {
            this.ir = null;
            this.install.setEnabled(false);
            this.installLabel.setText("");
        } else {
            this.ir = ServerPlugin.findInstallableRuntime((String)this.runtimeWC.getRuntimeType().getId());
            if (this.ir != null) {
                this.install.setEnabled(true);
                this.installLabel.setText(this.ir.getName());
            }
        }
        this.init();
        this.validate();
    }

    public void dispose() {
        super.dispose();
        if (this.installRuntimeJob != null) {
            this.installRuntimeJob.removeJobChangeListener(this.jobListener);
        }
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.libra.framework.ui.twnr0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.runtimeName);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.name = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OSGIFrameworkComposite.this.runtimeWC.setName(OSGIFrameworkComposite.this.name.getText());
                OSGIFrameworkComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.installDir);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.installDir = new Text((Composite)this, 2048);
        data = new GridData(768);
        this.installDir.setLayoutData((Object)data);
        this.installDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OSGIFrameworkComposite.this.runtimeWC.setLocation((IPath)new Path(OSGIFrameworkComposite.this.installDir.getText()));
                OSGIFrameworkComposite.this.validate();
            }
        });
        Button browse = SWTUtil.createButton(this, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(OSGIFrameworkComposite.this.getShell());
                dialog.setMessage(Messages.selectInstallDir);
                dialog.setFilterPath(OSGIFrameworkComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    OSGIFrameworkComposite.this.installDir.setText(selectedDirectory);
                }
            }
        });
        this.installLabel = new Label((Composite)this, 131072);
        data = new GridData(768);
        data.horizontalIndent = 10;
        this.installLabel.setLayoutData((Object)data);
        this.install = SWTUtil.createButton(this, Messages.install);
        this.install.setEnabled(false);
        this.install.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String license = null;
                try {
                    license = OSGIFrameworkComposite.this.ir.getLicense((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Trace.trace((byte)2, "Error getting license", e);
                }
                TaskModel taskModel = new TaskModel();
                taskModel.putObject("license", (Object)license);
                TaskWizard wizard2 = new TaskWizard(Messages.installDialogTitle, new WizardFragment(){

                    protected void createChildFragments(List list) {
                        list.add(new LicenseWizardFragment());
                    }
                }, taskModel);
                WizardDialog dialog2 = new WizardDialog(OSGIFrameworkComposite.this.getShell(), (IWizard)wizard2);
                if (dialog2.open() == 1) {
                    return;
                }
                DirectoryDialog dialog = new DirectoryDialog(OSGIFrameworkComposite.this.getShell());
                dialog.setMessage(Messages.selectInstallDir);
                dialog.setFilterPath(OSGIFrameworkComposite.this.installDir.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    Path installPath = new Path(selectedDirectory);
                    OSGIFrameworkComposite.this.installRuntimeJob = new Job("Installing osgi runtime environment", (IPath)installPath){
                        private final /* synthetic */ IPath val$installPath;
                        {
                            this.val$installPath = iPath;
                            super($anonymous0);
                        }

                        public boolean belongsTo(Object family) {
                            return "org.eclipse.wst.server.core".equals(family);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                (this).OSGIFrameworkComposite.this.ir.install(this.val$installPath, monitor);
                            }
                            catch (CoreException ce) {
                                return ce.getStatus();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    OSGIFrameworkComposite.this.installDir.setText(selectedDirectory);
                    OSGIFrameworkComposite.this.jobListener = new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            (this).OSGIFrameworkComposite.this.installRuntimeJob.removeJobChangeListener((IJobChangeListener)this);
                            (this).OSGIFrameworkComposite.this.installRuntimeJob = null;
                            Display.getDefault().asyncExec(new Runnable(){

                                public void run() {
                                    if (!OSGIFrameworkComposite.this.isDisposed()) {
                                        OSGIFrameworkComposite.this.validate();
                                    }
                                }
                            });
                        }
                    };
                    OSGIFrameworkComposite.this.installRuntimeJob.addJobChangeListener(OSGIFrameworkComposite.this.jobListener);
                    OSGIFrameworkComposite.this.installRuntimeJob.schedule();
                }
            }
        });
        this.updateJREs();
        label = new Label((Composite)this, 0);
        label.setText(Messages.installedJRE);
        data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.combo = new Combo((Composite)this, 12);
        this.combo.setItems(this.jreNames);
        data = new GridData(256);
        this.combo.setLayoutData((Object)data);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int sel = OSGIFrameworkComposite.this.combo.getSelectionIndex();
                IVMInstall vmInstall = null;
                if (sel > 0) {
                    vmInstall = (IVMInstall)OSGIFrameworkComposite.this.installedJREs.get(sel - 1);
                }
                OSGIFrameworkComposite.this.runtime.setVMInstall(vmInstall);
                OSGIFrameworkComposite.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button button = SWTUtil.createButton(this, Messages.installedJREs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = OSGIFrameworkComposite.this.combo.getText();
                if (OSGIFrameworkComposite.this.showPreferencePage()) {
                    OSGIFrameworkComposite.this.updateJREs();
                    OSGIFrameworkComposite.this.combo.setItems(OSGIFrameworkComposite.this.jreNames);
                    OSGIFrameworkComposite.this.combo.setText(currentVM);
                    if (OSGIFrameworkComposite.this.combo.getSelectionIndex() == -1) {
                        OSGIFrameworkComposite.this.combo.select(0);
                    }
                    OSGIFrameworkComposite.this.validate();
                }
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.name.forceFocus();
    }

    protected void updateJREs() {
        this.installedJREs = new ArrayList();
        IVMInstallType[] vmInstallTypes = JavaRuntime.getVMInstallTypes();
        int size = vmInstallTypes.length;
        int i = 0;
        while (i < size) {
            IVMInstall[] vmInstalls = vmInstallTypes[i].getVMInstalls();
            int size2 = vmInstalls.length;
            int j = 0;
            while (j < size2) {
                this.installedJREs.add(vmInstalls[j]);
                ++j;
            }
            ++i;
        }
        size = this.installedJREs.size();
        this.jreNames = new String[size + 1];
        this.jreNames[0] = Messages.runtimeDefaultJRE;
        i = 0;
        while (i < size) {
            IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
            this.jreNames[i + 1] = vmInstall.getName();
            ++i;
        }
    }

    protected boolean showPreferencePage() {
        String id = "org.eclipse.jdt.debug.ui.preferences.VMPreferencePage";
        PreferenceManager manager = PlatformUI.getWorkbench().getPreferenceManager();
        IPreferenceNode node = manager.find("org.eclipse.jdt.ui.preferences.JavaBasePreferencePage").findSubNode(id);
        PreferenceManager manager2 = new PreferenceManager();
        manager2.addToRoot(node);
        PreferenceDialog dialog = new PreferenceDialog(this.getShell(), manager2);
        dialog.create();
        return dialog.open() == 0;
    }

    protected void init() {
        if (this.name == null || this.runtime == null) {
            return;
        }
        if (this.runtimeWC.getName() != null) {
            this.name.setText(this.runtimeWC.getName());
        } else {
            this.name.setText("");
        }
        if (this.runtimeWC.getLocation() != null) {
            this.installDir.setText(this.runtimeWC.getLocation().toOSString());
        } else {
            this.installDir.setText("");
        }
        if (this.runtime.isUsingDefaultJRE()) {
            this.combo.select(0);
        } else {
            boolean found = false;
            int size = this.installedJREs.size();
            int i = 0;
            while (i < size) {
                IVMInstall vmInstall = (IVMInstall)this.installedJREs.get(i);
                if (vmInstall.equals(this.runtime.getVMInstall())) {
                    this.combo.select(i + 1);
                    found = true;
                }
                ++i;
            }
            if (!found) {
                this.combo.select(0);
            }
        }
    }

    protected void validate() {
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        IStatus status = this.runtimeWC.validate(null);
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }
}

