/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.TomcatVersionHelper;
import org.eclipse.wst.server.core.IModule;

public class Tomcat85Handler
implements ITomcatVersionHandler {
    @Override
    public IStatus verifyInstallPath(IPath installPath) {
        IStatus result = TomcatVersionHelper.checkCatalinaVersion(installPath, "org.eclipse.jst.server.tomcat.85");
        if (result.getSeverity() == 8) {
            result = TomcatPlugin.verifyInstallPathWithFolderCheck(installPath, "org.eclipse.jst.server.tomcat.85");
        }
        return result;
    }

    @Override
    public String getRuntimeClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    @Override
    public List getRuntimeClasspath(IPath installPath, IPath configPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("bootstrap.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            path = binPath.append("commons-daemon.jar");
            if (path.toFile().exists()) {
                cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            }
            if ((path = binPath.append("tomcat-juli.jar")).toFile().exists()) {
                cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            } else if (configPath != null && (path = configPath.append("bin/tomcat-juli.jar")).toFile().exists()) {
                cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            }
        }
        return cp;
    }

    @Override
    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (starting) {
            list.add("start");
        } else {
            list.add("stop");
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    @Override
    public String[] getExcludedRuntimeProgramArguments(boolean debug, boolean starting) {
        return null;
    }

    @Override
    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, IPath deployPath, boolean isTestEnv) {
        return TomcatVersionHelper.getCatalinaVMArguments(installPath, configPath, deployPath, isTestEnv);
    }

    @Override
    public String getRuntimePolicyFile(IPath configPath) {
        return configPath.append("conf").append("catalina.policy").toOSString();
    }

    @Override
    public IStatus canAddModule(IModule module) {
        String version = module.getModuleType().getVersion();
        if ("2.2".equals(version) || "2.3".equals(version) || "2.4".equals(version) || "2.5".equals(version) || "3.0".equals(version) || "3.1".equals(version)) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec85, null);
    }

    @Override
    public IPath getRuntimeBaseDirectory(TomcatServer server) {
        return TomcatVersionHelper.getStandardBaseDirectory(server);
    }

    @Override
    public IStatus prepareRuntimeDirectory(IPath baseDir) {
        return TomcatVersionHelper.createCatalinaInstanceDirectory(baseDir);
    }

    @Override
    public IStatus prepareDeployDirectory(IPath deployPath) {
        return TomcatVersionHelper.createDeploymentDirectory(deployPath, "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<web-app xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd\" version=\"2.5\">\n</web-app>");
    }

    @Override
    public IStatus prepareForServingDirectly(IPath baseDir, TomcatServer server, String tomcatVersion) {
        return Status.OK_STATUS;
    }

    @Override
    public String getSharedLoader(IPath baseDir) {
        return "common";
    }

    @Override
    public boolean supportsServeModulesWithoutPublish() {
        return true;
    }

    @Override
    public boolean supportsDebugArgument() {
        return false;
    }

    @Override
    public boolean supportsSeparateContextFiles() {
        return true;
    }

    @Override
    public String getEndorsedDirectories(IPath installPath) {
        return installPath.append("endorsed").toOSString();
    }
}

