/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.text;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.text.JavaHeuristicScanner;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.typing.AbstractCharacterPairInserter;

public class JavaCharacterPairInserter
extends AbstractCharacterPairInserter
implements IPropertyChangeListener {
    private boolean fCloseBrackets = true;
    private boolean fCloseStrings = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean shouldPair(ISourceViewer viewer, char c) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            IRegion endLine = document.getLineInformationOfOffset(offset + length);
            JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
            int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
            String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
            int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
            int prevTokenOffset = scanner.getPosition() + 1;
            String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
            switch (c) {
                case '(': {
                    if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) return true;
                    return false;
                }
                case '<': {
                    if (this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) return true;
                    return false;
                }
                case '[': {
                    if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) return true;
                    return false;
                }
                case '\"': 
                case '\'': {
                    if (this.fCloseStrings && nextToken != 2000 && prevToken != 2000 && prevToken != 15 && nextToken != 15 && prevToken != 16 && nextToken != 16 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1)) return true;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isAngularIntroducer(String identifier) {
        return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
    }

    protected char getPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return c;
            }
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '<': {
                return '>';
            }
        }
        throw new IllegalArgumentException();
    }

    protected char getEscapeChar(char c) {
        switch (c) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    public boolean hasPair(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '(': 
            case '<': 
            case '[': {
                return true;
            }
        }
        return false;
    }

    public void initialize() {
        IPreferenceStore store = JSPUIPlugin.getInstance().getPreferenceStore();
        this.fCloseStrings = store.getBoolean("closeStrings");
        this.fCloseBrackets = store.getBoolean("closeBrackets");
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        JSPUIPlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("closeBrackets".equals(event.getProperty())) {
            this.fCloseBrackets = (Boolean)event.getNewValue();
        } else if ("closeStrings".equals(event.getProperty())) {
            this.fCloseStrings = (Boolean)event.getNewValue();
        }
    }
}

