/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry.taglib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractJEEModelProviderQuery;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.jst.jsf.common.internal.resource.EventResult;
import org.eclipse.jst.jsf.common.internal.resource.ILifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.common.internal.resource.WorkspaceMediator;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebappConfiguration {
    public static final String FACELET_10_LIBRARIES_CONTEXT_PARAM_NAME = "facelets.LIBRARIES";
    public static final String JSF20_FACELET_LIBRARIES_CONTEXT_PARAM_NAME = "javax.faces.FACELETS_LIBRARIES";
    private final IProject _project;
    private final ContextParamAdapter _contextParamAdapter;
    private List<IFile> _cachedFiles;
    private final AbstractJEEModelProviderQuery _modelProvider;
    private final AbstractVirtualComponentQuery _vcQuery;
    private final LifecycleListener _lifecycleListener;
    private final WorkspaceMediator _wsMediator;

    public WebappConfiguration(IProject project, AbstractJEEModelProviderQuery webAppProvider, AbstractVirtualComponentQuery vcQuery, WorkspaceMediator wsMediator) {
        this._project = project;
        this._vcQuery = vcQuery;
        this._lifecycleListener = new LifecycleListener((IResource)this.getWebXmlFile(project), project.getWorkspace());
        this._contextParamAdapter = new ContextParamAdapter();
        this._modelProvider = webAppProvider;
        this._wsMediator = wsMediator;
    }

    public void addListener(WebappListener listener) {
        this._contextParamAdapter.addListener(listener);
    }

    public void removeListener(WebappListener listener) {
        this._contextParamAdapter.removeListener(listener);
    }

    public List<IFile> getFiles() {
        IVirtualFolder folder = this._vcQuery.getWebContentFolder(this._project);
        if (folder == null) {
            return Collections.emptyList();
        }
        IContainer underlyingContainer = folder.getUnderlyingFolder();
        if (underlyingContainer == null) {
            return Collections.emptyList();
        }
        List<String> filenames = WebappConfiguration.getConfigFilesFromContextParam(this._project, this._modelProvider);
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (String filename : filenames) {
            IFile vfile = underlyingContainer.getFile((IPath)new Path(filename));
            if (vfile == null || !vfile.isAccessible()) continue;
            files.add(vfile);
        }
        this._cachedFiles = files;
        return Collections.unmodifiableList(this._cachedFiles);
    }

    private IFile getWebXmlFile(IProject project) {
        IVirtualFolder webContentFolder = this._vcQuery.getWebContentFolder(project);
        IContainer folder = webContentFolder.getUnderlyingFolder();
        return folder.getFile((IPath)new Path("WEB-INF/web.xml"));
    }

    public void start() {
        this._lifecycleListener.addListener((ILifecycleListener)this._contextParamAdapter);
    }

    public void stop() {
        this._lifecycleListener.removeListener((ILifecycleListener)this._contextParamAdapter);
    }

    public void dispose() {
        this._lifecycleListener.dispose();
    }

    public static List<String> getConfigFilesFromContextParam(IProject project, AbstractJEEModelProviderQuery modelProvider) {
        ArrayList<String> filesList = new ArrayList<String>(5);
        List paramValues = modelProvider.getWebAppParamValues();
        for (ParamValue paramValue : paramValues) {
            if (!paramValue.getParamName().equals(FACELET_10_LIBRARIES_CONTEXT_PARAM_NAME) && !paramValue.getParamName().equals(JSF20_FACELET_LIBRARIES_CONTEXT_PARAM_NAME)) continue;
            String filesString = paramValue.getParamValue();
            filesList.addAll(WebappConfiguration.parseFilesString(filesString));
        }
        return filesList.isEmpty() ? Collections.EMPTY_LIST : filesList;
    }

    private static List<String> parseFilesString(String filesString) {
        ArrayList<String> filesList = new ArrayList<String>();
        if (filesString != null && filesString.trim().length() > 0) {
            StringTokenizer stFilesString = new StringTokenizer(filesString, ";");
            while (stFilesString.hasMoreTokens()) {
                String configFile = stFilesString.nextToken().trim();
                filesList.add(configFile);
            }
        }
        return filesList;
    }

    private class ContextParamAdapter
    implements IResourceLifecycleListener {
        private final CopyOnWriteArrayList<WebappListener> _listeners = new CopyOnWriteArrayList();

        private ContextParamAdapter() {
        }

        public void addListener(WebappListener listener) {
            this._listeners.addIfAbsent(listener);
        }

        public void removeListener(WebappListener listener) {
            this._listeners.remove(listener);
        }

        private void fireEvent(WebappListener.WebappChangeEvent event) {
            for (WebappListener listener : this._listeners) {
                listener.webappChanged(event);
            }
        }

        private void checkAndFireFileChanges() {
            List oldFiles = WebappConfiguration.this._cachedFiles == null ? Collections.EMPTY_LIST : WebappConfiguration.this._cachedFiles;
            List<IFile> newFiles = WebappConfiguration.this.getFiles();
            ArrayList<IFile> filesAdded = new ArrayList<IFile>();
            ArrayList<IFile> filesRemoved = new ArrayList<IFile>();
            for (IFile oldFile : oldFiles) {
                if (newFiles.contains(oldFile)) continue;
                filesRemoved.add(oldFile);
            }
            for (IFile newFile : newFiles) {
                if (oldFiles.contains(newFile)) continue;
                filesAdded.add(newFile);
            }
            if (filesAdded.size() > 0 || filesRemoved.size() > 0) {
                this.fireEvent(new WebappListener.WebappChangeEvent(filesRemoved, filesAdded));
            }
        }

        protected void processParamValue(ParamValue contextParam) {
            this.checkAndFireFileChanges();
        }

        public EventResult acceptEvent(ResourceLifecycleEvent event) {
            if (event.getAffectedResource() instanceof IFile && "web.xml".equals(event.getAffectedResource().getProjectRelativePath().lastSegment()) && event.getEventType() == ResourceLifecycleEvent.EventType.RESOURCE_CHANGED) {
                this.handleChange();
            }
            return EventResult.getDefaultEventResult();
        }

        private void handleChange() {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    List webAppParamValues = WebappConfiguration.this._modelProvider.getWebAppParamValues();
                    for (ParamValue paramValue : webAppParamValues) {
                        ContextParamAdapter.this.processParamValue(paramValue);
                    }
                }
            };
            WebappConfiguration.this._wsMediator.runInWorkspaceJob(runnable, "Update web xml");
        }
    }

    static abstract class WebappListener {
        WebappListener() {
        }

        public abstract void webappChanged(WebappChangeEvent var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class WebappChangeEvent {
            private final List<IFile> _removed;
            private final List<IFile> _added;

            WebappChangeEvent(List<IFile> removed, List<IFile> added) {
                this._removed = Collections.unmodifiableList(removed);
                this._added = Collections.unmodifiableList(added);
            }

            public final List<IFile> getRemoved() {
                return this._removed;
            }

            public final List<IFile> getAdded() {
                return this._added;
            }
        }
    }
}

