/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementListIterable;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.VirtualJoinColumn;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedReferenceTable;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ReferenceTableAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class GenericJavaReferenceTable<P extends JpaContextModel, PA extends Table.ParentAdapter<P>, A extends ReferenceTableAnnotation>
extends AbstractJavaTable<P, PA, A>
implements JavaSpecifiedReferenceTable {
    protected final AbstractJpaContextModel.ContextListContainer<JavaSpecifiedJoinColumn, JoinColumnAnnotation> specifiedJoinColumnContainer;
    protected final JoinColumn.ParentAdapter joinColumnParentAdapter = this.buildJoinColumnParentAdapter();
    protected JavaSpecifiedJoinColumn defaultJoinColumn;

    protected GenericJavaReferenceTable(PA parentAdapter) {
        super(parentAdapter);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.syncSpecifiedJoinColumns(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.updateModels((Iterable<? extends JpaContextModel>)this.getSpecifiedJoinColumns(), monitor);
        this.updateDefaultJoinColumn(monitor);
    }

    @Override
    public ListIterable<JavaSpecifiedJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultJoinColumnToSpecified() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterable<JavaSpecifiedJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer;
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public JavaSpecifiedJoinColumn getSpecifiedJoinColumn(int index) {
        return (JavaSpecifiedJoinColumn)this.specifiedJoinColumnContainer.get(index);
    }

    @Override
    public JavaSpecifiedJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public JavaSpecifiedJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = ((ReferenceTableAnnotation)this.getTableAnnotation()).addJoinColumn(index);
        return (JavaSpecifiedJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(SpecifiedJoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOf((JavaSpecifiedJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).removeJoinColumn(index);
        this.removeTableAnnotationIfUnset();
        this.specifiedJoinColumnContainer.remove(index);
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).moveJoinColumn(targetIndex, sourceIndex);
        this.specifiedJoinColumnContainer.move(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        int index = this.getSpecifiedJoinColumnsSize();
        while (--index >= 0) {
            ((ReferenceTableAnnotation)this.getTableAnnotation()).removeJoinColumn(index);
        }
        this.removeTableAnnotationIfUnset();
        this.specifiedJoinColumnContainer.clear();
    }

    protected void syncSpecifiedJoinColumns(IProgressMonitor monitor) {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel(monitor);
    }

    protected ListIterable<JoinColumnAnnotation> getJoinColumnAnnotations() {
        return ((ReferenceTableAnnotation)this.getTableAnnotation()).getJoinColumns();
    }

    protected AbstractJpaContextModel.ContextListContainer<JavaSpecifiedJoinColumn, JoinColumnAnnotation> buildSpecifiedJoinColumnContainer() {
        return this.buildSpecifiedContextListContainer("specifiedJoinColumns", new SpecifiedJoinColumnContainerAdapter());
    }

    protected abstract JoinColumn.ParentAdapter buildJoinColumnParentAdapter();

    @Override
    public JavaSpecifiedJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaSpecifiedJoinColumn joinColumn) {
        JavaSpecifiedJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaSpecifiedJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn(IProgressMonitor monitor) {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumnAnnotation((JavaResourceModel)this.getTableAnnotation())));
            } else {
                this.defaultJoinColumn.update(monitor);
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(VirtualReferenceTable virtualTable) {
        super.initializeFrom(virtualTable);
        for (VirtualJoinColumn joinColumn : virtualTable.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected JavaSpecifiedJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(this.joinColumnParentAdapter, joinColumnAnnotation);
    }

    protected JavaSpecifiedJoinColumn buildJoinColumn(JoinColumn.ParentAdapter jcParentAdapter, JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(jcParentAdapter, joinColumnAnnotation);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (JavaSpecifiedJoinColumn column : this.getJoinColumns()) {
            result = column.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateModels((Iterable<? extends JpaContextModel>)this.getJoinColumns(), messages, reporter);
    }

    public class SpecifiedJoinColumnContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<JavaSpecifiedJoinColumn, JoinColumnAnnotation> {
        public SpecifiedJoinColumnContainerAdapter() {
            super(GenericJavaReferenceTable.this);
        }

        @Override
        public JavaSpecifiedJoinColumn buildContextElement(JoinColumnAnnotation resourceElement) {
            return GenericJavaReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        public ListIterable<JoinColumnAnnotation> getResourceElements() {
            return GenericJavaReferenceTable.this.getJoinColumnAnnotations();
        }

        @Override
        public JoinColumnAnnotation extractResourceElement(JavaSpecifiedJoinColumn contextElement) {
            return (JoinColumnAnnotation)contextElement.getColumnAnnotation();
        }
    }
}

