/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.context;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.text.edits.ReplaceEdit;

public interface TypeRefactoringParticipant {
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType var1, String var2);

    public Iterable<ReplaceEdit> createMoveTypeEdits(IType var1, IPackageFragment var2);

    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment var1, String var2);

    public static class MoveTypeEditsTransformer
    extends TransformerAdapter<TypeRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IType originalType;
        protected final IPackageFragment newPackage;

        public MoveTypeEditsTransformer(IType originalType, IPackageFragment newPackage) {
            this.originalType = originalType;
            this.newPackage = newPackage;
        }

        public Iterable<ReplaceEdit> transform(TypeRefactoringParticipant participant) {
            return participant.createMoveTypeEdits(this.originalType, this.newPackage);
        }
    }

    public static class RenamePackageEditsTransformer
    extends TransformerAdapter<TypeRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IPackageFragment originalPackage;
        protected final String newName;

        public RenamePackageEditsTransformer(IPackageFragment originalPackage, String newName) {
            this.originalPackage = originalPackage;
            this.newName = newName;
        }

        public Iterable<ReplaceEdit> transform(TypeRefactoringParticipant participant) {
            return participant.createRenamePackageEdits(this.originalPackage, this.newName);
        }
    }

    public static class RenameTypeEditsTransformer
    extends TransformerAdapter<TypeRefactoringParticipant, Iterable<ReplaceEdit>> {
        protected final IType originalType;
        protected final String newName;

        public RenameTypeEditsTransformer(IType originalType, String newName) {
            this.originalType = originalType;
            this.newName = newName;
        }

        public Iterable<ReplaceEdit> transform(TypeRefactoringParticipant participant) {
            return participant.createRenameTypeEdits(this.originalType, this.newName);
        }
    }
}

