/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.figures.ImageFigureAntialias;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class GFImageFigure
extends ImageFigureAntialias {
    private GraphicsAlgorithm graphicsAlgorithm;
    private Image fillImage = null;
    private boolean isSelfCreatedImage = false;

    public GFImageFigure(GraphicsAlgorithm graphicsAlgorithm) {
        this.graphicsAlgorithm = graphicsAlgorithm;
    }

    public void setImage(Image image) {
        this.disposeSelfCreatedImage();
        if (image != null && this.graphicsAlgorithm instanceof org.eclipse.graphiti.mm.algorithms.Image) {
            org.eclipse.graphiti.mm.algorithms.Image imageGA = (org.eclipse.graphiti.mm.algorithms.Image)this.graphicsAlgorithm;
            if (imageGA.getStretchH().booleanValue() || imageGA.getStretchV().booleanValue()) {
                double scalefactorX = 1.0;
                double scalefactorY = 1.0;
                ImageData originalImageData = image.getImageData();
                int imageWidth = originalImageData.width;
                int imageHeight = originalImageData.height;
                if (imageGA.getStretchH().booleanValue()) {
                    scalefactorX = (double)this.graphicsAlgorithm.getWidth() / (double)imageWidth;
                }
                if (imageGA.getStretchV().booleanValue()) {
                    scalefactorY = (double)this.graphicsAlgorithm.getHeight() / (double)imageHeight;
                }
                if (imageGA.getProportional().booleanValue()) {
                    double actualScalefactor = 0.0;
                    actualScalefactor = scalefactorX < scalefactorY ? scalefactorX : scalefactorY;
                    scalefactorX = actualScalefactor;
                    scalefactorY = actualScalefactor;
                }
                double d = (double)imageWidth * scalefactorX;
                double e = (double)imageHeight * scalefactorY;
                this.fillImage = new Image((Device)Display.getCurrent(), originalImageData.scaledTo((int)d, (int)e));
                this.isSelfCreatedImage = true;
            } else {
                this.fillImage = image;
            }
        } else {
            this.fillImage = image;
        }
        super.setImage(this.fillImage);
    }

    private void disposeSelfCreatedImage() {
        if (this.isSelfCreatedImage) {
            if (this.fillImage != null && !this.fillImage.isDisposed()) {
                this.fillImage.dispose();
            }
            this.isSelfCreatedImage = false;
        }
    }

    @Override
    public void paintFigure(Graphics graphics) {
        if (this.graphicsAlgorithm != null && GraphitiInternal.getEmfService().isObjectAlive((EObject)this.graphicsAlgorithm)) {
            double transparency = Graphiti.getGaService().getTransparency(this.graphicsAlgorithm, true);
            int alpha = (int)((1.0 - transparency) * 255.0);
            graphics.setAlpha(alpha);
        }
        super.paintFigure(graphics);
    }
}

