/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.models;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import org.eclipse.gef.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef.common.collections.CollectionUtils;
import org.eclipse.gef.mvc.fx.handlers.ISnapToStrategy;
import org.eclipse.gef.mvc.fx.parts.IContentPart;

public class SnappingModel {
    public static final String SNAPPING_LOCATIONS_PROPERTY = "snappingLocations";
    public static final String SNAP_TO_STRATEGIES_PROPERTY = "snapToStrategies";
    private ObservableList<SnappingLocation> snappingLocations = CollectionUtils.observableArrayList();
    private ReadOnlyListWrapper<SnappingLocation> snappingLocationsProperty = new ReadOnlyListWrapperEx((Object)this, "snappingLocations", this.snappingLocations);
    private ObservableList<ISnapToStrategy> snapToStrategies = CollectionUtils.observableArrayList();
    private ReadOnlyListWrapper<ISnapToStrategy> snapToStrategiesProperty = new ReadOnlyListWrapperEx((Object)this, "snapToStrategies", this.snapToStrategies);

    public List<SnappingLocation> getSnappingLocations() {
        return this.snappingLocationsProperty.get();
    }

    public List<SnappingLocation> getSnappingLocationsFor(IContentPart<? extends Node> part) {
        ArrayList<SnappingLocation> locations = new ArrayList<SnappingLocation>();
        for (SnappingLocation p : this.getSnappingLocations()) {
            if (p.getPart() != part) continue;
            locations.add(p);
        }
        return locations;
    }

    public void setSnappingLocations(List<? extends SnappingLocation> snappingLocations) {
        if (!this.snappingLocationsProperty.equals(snappingLocations)) {
            this.snappingLocationsProperty.setAll(snappingLocations);
        }
    }

    public ReadOnlyListProperty<SnappingLocation> snappingLocationsProperty() {
        return this.snappingLocationsProperty.getReadOnlyProperty();
    }

    public ReadOnlyListProperty<ISnapToStrategy> snapToStrategiesProperty() {
        return this.snapToStrategiesProperty.getReadOnlyProperty();
    }

    public static class SnappingLocation {
        private IContentPart<? extends Node> part;
        private Orientation orientation;
        private double positionInScene;

        public SnappingLocation(IContentPart<? extends Node> part, Orientation orientation, double positionInScene) {
            this.part = part;
            this.orientation = orientation;
            this.positionInScene = positionInScene;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SnappingLocation other = (SnappingLocation)obj;
            if (this.orientation != other.orientation) {
                return false;
            }
            if (this.part == null ? other.part != null : !this.part.equals(other.part)) {
                return false;
            }
            return Double.doubleToLongBits(this.positionInScene) == Double.doubleToLongBits(other.positionInScene);
        }

        public SnappingLocation getCopy() {
            return new SnappingLocation(this.getPart(), this.getOrientation(), this.getPositionInScene());
        }

        public Orientation getOrientation() {
            return this.orientation;
        }

        public IContentPart<? extends Node> getPart() {
            return this.part;
        }

        public double getPositionInScene() {
            return this.positionInScene;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.orientation == null ? 0 : this.orientation.hashCode());
            result = 31 * result + (this.part == null ? 0 : this.part.hashCode());
            long temp = Double.doubleToLongBits(this.positionInScene);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public void setOrientation(Orientation orientation) {
            this.orientation = orientation;
        }

        public void setPart(IContentPart<? extends Node> part) {
            this.part = part;
        }

        public void setPositionInScene(double positionInScene) {
            this.positionInScene = positionInScene;
        }

        public String toString() {
            return "SnappingLocation[part=" + this.getPart().getClass().getSimpleName() + "@" + System.identityHashCode(this.getPart()) + ", orientation=" + this.getOrientation() + ", position=" + this.getPositionInScene() + "]";
        }
    }
}

