/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.staging;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.staging.FixedJFaceToolTip;
import org.eclipse.egit.ui.internal.staging.StagingEntry;
import org.eclipse.egit.ui.internal.staging.StagingFolderEntry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class StagingViewTooltips
extends FixedJFaceToolTip {
    private final ColumnViewer viewer;
    private final IAction[] actions;

    protected StagingViewTooltips(ColumnViewer viewer, IAction ... actions) {
        super(viewer.getControl(), 2, false);
        Assert.isLegal((actions != null && actions.length > 0 ? 1 : 0) != 0);
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            Assert.isNotNull((Object)action.getImageDescriptor());
            Assert.isLegal(((action.getStyle() & 4) == 0 ? 1 : 0) != 0);
            ++n2;
        }
        this.viewer = viewer;
        this.actions = actions;
        this.setHideOnMouseDown(false);
    }

    protected ViewerCell getToolTipArea(Event event) {
        return this.viewer.getCell(new Point(event.x, event.y));
    }

    @Override
    protected boolean shouldCreateToolTip(Event event) {
        return super.shouldCreateToolTip(event) && this.isSelected(event);
    }

    private boolean isSelected(Event event) {
        ViewerCell currentCell = this.getToolTipArea(event);
        if (currentCell == null || currentCell.getColumnIndex() > 0 && !currentCell.getText().isEmpty()) {
            return false;
        }
        Object item = currentCell.getElement();
        if (!(item instanceof StagingEntry) && !(item instanceof StagingFolderEntry)) {
            return false;
        }
        ISelection selection = this.viewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        Iterator selectedObjects = ((IStructuredSelection)selection).iterator();
        while (selectedObjects.hasNext()) {
            if (item != selectedObjects.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Composite createToolTipContentArea(Event event, Composite parent) {
        ToolBar bar = new ToolBar(parent, 0x800100);
        IAction[] iActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            final IAction action = iActionArray[n2];
            ToolItem item = new ToolItem(bar, 8);
            item.setImage(UIIcons.getImage(Activator.getDefault().getResourceManager(), action.getImageDescriptor()));
            String tooltip = action.getToolTipText();
            if (tooltip == null || tooltip.isEmpty()) {
                tooltip = action.getText();
            }
            item.setToolTipText(tooltip);
            item.setEnabled(true);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StagingViewTooltips.this.hide();
                    if (action.isEnabled()) {
                        action.run();
                    }
                }
            });
            ++n2;
        }
        return bar;
    }
}

