/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.properties.GitPropertyDescriptor;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CommitPropertyDescriptor
extends GitPropertyDescriptor {
    static final int COLUMN_INDEX = 1;
    private final RepositoryCommit commit;

    public CommitPropertyDescriptor(Object id, String label, RepositoryCommit commit) {
        super(id, label);
        this.commit = commit;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return new ButtonCellEditor(parent);
    }

    private class ButtonCellEditor
    extends CellEditor {
        private Composite editor;
        private Object content;
        private Button openCommit;
        private Button showInHistory;
        private FocusListener listener;
        private Listener parentListener;

        ButtonCellEditor(Composite parent) {
            super(parent);
        }

        protected Control createControl(Composite parent) {
            this.editor = new Composite(parent, 0);
            this.openCommit = new Button(this.editor, 8);
            this.openCommit.setImage(UIIcons.getImage(Activator.getDefault().getResourceManager(), UIIcons.OPEN_COMMIT));
            this.openCommit.setToolTipText(UIText.CommitPropertyDescriptor_OpenCommitLabel);
            this.openCommit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evenet) {
                    try {
                        CommitEditor.open(CommitPropertyDescriptor.this.commit);
                    }
                    catch (PartInitException e) {
                        Activator.showError(e.getLocalizedMessage(), e);
                    }
                }
            });
            this.showInHistory = new Button(this.editor, 8);
            this.showInHistory.setImage(UIIcons.getImage(Activator.getDefault().getResourceManager(), UIIcons.HISTORY));
            this.showInHistory.setToolTipText(UIText.CommitPropertyDescriptor_ShowInHistoryLabel);
            this.showInHistory.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    try {
                        IHistoryView view = (IHistoryView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.team.ui.GenericHistoryView");
                        view.showHistoryFor((Object)CommitPropertyDescriptor.this.commit);
                    }
                    catch (PartInitException e) {
                        Activator.showError(e.getLocalizedMessage(), e);
                    }
                }
            });
            KeyAdapter closeEditor = new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        ButtonCellEditor.this.fireCancelEditor();
                    }
                }
            };
            this.openCommit.addKeyListener((KeyListener)closeEditor);
            this.showInHistory.addKeyListener((KeyListener)closeEditor);
            Tree tree = (Tree)parent;
            TreeItem[] selected = tree.getSelection();
            TreeItem item = selected == null || selected.length == 0 ? null : selected[0];
            this.editor.setLayout((Layout)new ToolbarLayout(item, 1));
            return this.editor;
        }

        protected Object doGetValue() {
            return this.content;
        }

        protected void doSetValue(Object value) {
            this.content = value;
        }

        protected void doSetFocus() {
            if (this.listener == null) {
                this.listener = new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        ButtonCellEditor.this.editor.getDisplay().asyncExec(() -> {
                            if (!ButtonCellEditor.this.openCommit.isFocusControl() && !ButtonCellEditor.this.showInHistory.isFocusControl()) {
                                ButtonCellEditor.this.focusLost();
                            }
                        });
                    }
                };
            }
            this.openCommit.addFocusListener(this.listener);
            this.showInHistory.addFocusListener(this.listener);
            if (this.parentListener == null) {
                this.parentListener = event -> {
                    switch (event.type) {
                        case 17: 
                        case 18: {
                            this.fireCancelEditor();
                            break;
                        }
                    }
                };
            }
            this.editor.getParent().addListener(18, this.parentListener);
            this.editor.getParent().addListener(17, this.parentListener);
            this.editor.setFocus();
        }

        public void deactivate() {
            if (this.listener != null) {
                this.openCommit.removeFocusListener(this.listener);
                this.showInHistory.removeFocusListener(this.listener);
            }
            if (this.parentListener != null) {
                this.editor.getParent().removeListener(18, this.parentListener);
                this.editor.getParent().removeListener(17, this.parentListener);
            }
            super.deactivate();
        }

        private class ToolbarLayout
        extends Layout {
            private final TreeItem item;
            private final int idx;

            ToolbarLayout(TreeItem item, int columnIndex) {
                this.item = item;
                this.idx = columnIndex;
            }

            public void layout(Composite cellEditor, boolean force) {
                Point size = ButtonCellEditor.this.openCommit.computeSize(-1, -1, force);
                Point size2 = ButtonCellEditor.this.showInHistory.computeSize(-1, -1, force);
                int width = size.x + size2.x;
                int height = Math.max(size.y, size2.y);
                Rectangle editorBounds = cellEditor.getBounds();
                if (this.item != null) {
                    Point textSize;
                    GC gc = null;
                    try {
                        gc = new GC((Drawable)cellEditor.getDisplay());
                        gc.setFont(this.item.getFont(this.idx));
                        textSize = gc.stringExtent(this.item.getText(this.idx));
                    }
                    finally {
                        if (gc != null) {
                            gc.dispose();
                        }
                    }
                    if (textSize.x >= 0 && textSize.x < editorBounds.width) {
                        editorBounds.width = textSize.x == 0 ? 0 : textSize.x + LayoutConstants.getSpacing().x;
                        editorBounds.width += width;
                    }
                }
                editorBounds.x += editorBounds.width - width;
                editorBounds.width = width;
                if (height > editorBounds.height) {
                    editorBounds.y -= (height - editorBounds.height) / 2;
                    editorBounds.height = height;
                } else if (height < editorBounds.height) {
                    editorBounds.y += (editorBounds.height - height) / 2;
                    editorBounds.height = height;
                }
                cellEditor.setBounds(editorBounds);
                ButtonCellEditor.this.openCommit.setBounds(0, 0, size.x, size.y);
                ButtonCellEditor.this.showInHistory.setBounds(size.x, 0, size2.x, size2.y);
            }

            public Point computeSize(Composite cellEditor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point size = ButtonCellEditor.this.openCommit.computeSize(-1, -1, force);
                Point size2 = ButtonCellEditor.this.showInHistory.computeSize(-1, -1, force);
                return new Point(size.x + size2.x, Math.max(size.y, size2.y));
            }
        }
    }
}

