/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.LogUtility;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.ITopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.TopologyManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;

public class TopologyManager
implements EventListenerHook,
RemoteServiceAdminListener,
ITopologyManager {
    private Map<Bundle, List<EndpointEventHolder>> bundleEndpointEventListenerMap = new HashMap<Bundle, List<EndpointEventHolder>>();
    protected TopologyManagerImpl topologyManagerImpl;
    protected ServiceRegistration<?> endpointListenerRegistration;
    protected List<String> matchingFilters;

    protected void activate(BundleContext context, Map<String, ?> properties) throws Exception {
        String elString;
        String extraConditional;
        String extraFilters;
        Boolean endpointAllowLocalhost;
        String endpointConditionalOp = (String)properties.get("conditionalOp");
        if (endpointConditionalOp == null) {
            endpointConditionalOp = ENDPOINT_CONDITIONAL_OP;
        }
        if ((endpointAllowLocalhost = (Boolean)properties.get("allowLocalhost")) == null) {
            endpointAllowLocalhost = ENDPOINT_ALLOWLOCALHOST;
        }
        if ((extraFilters = (String)properties.get("extraFilters")) == null) {
            extraFilters = ENDPOINT_EXTRA_FILTERS;
        }
        String[] extraFiltersArr = null;
        if (extraFilters != null) {
            extraFiltersArr = extraFilters.split(",");
        }
        if ((extraConditional = (String)properties.get("conditional")) == null) {
            extraConditional = ENDPOINT_EXTRA_CONDITIONAL;
        }
        this.matchingFilters = Collections.synchronizedList(new ArrayList());
        this.topologyManagerImpl = new TopologyManagerImpl(context);
        StringBuffer elScope = new StringBuffer("");
        if (endpointConditionalOp != null && !"".equals(endpointConditionalOp)) {
            elScope.append("(").append(endpointConditionalOp).append("(");
            if (!ENDPOINT_ALLOWLOCALHOST) {
                elScope.append("!(").append("endpoint.framework.uuid").append("=").append(this.topologyManagerImpl.getFrameworkUUID()).append(")");
            }
            elScope.append(")");
            elScope.append("(ecf.endpoint.id.ns=*)");
            if (extraConditional != null && !"".equals(extraConditional)) {
                elScope.append(extraConditional);
            }
            elScope.append(")");
        }
        if (!"".equals(elString = elScope.toString())) {
            this.matchingFilters.add(elString);
        }
        if (extraFiltersArr != null) {
            String[] stringArray = extraFiltersArr;
            int n = extraFiltersArr.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                if (filter != null && !"".equals(filter)) {
                    this.matchingFilters.add(filter);
                }
                ++n2;
            }
        }
        Dictionary<String, Object> props = this.createEndpointListenerProps(this.matchingFilters);
        this.endpointListenerRegistration = context.registerService(EndpointEventListener.class, (ServiceFactory)new ServiceFactory<EndpointEventListener>(){

            public EndpointEventListener getService(Bundle bundle, ServiceRegistration<EndpointEventListener> registration) {
                return new ProxyEndpointEventListener(bundle);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ungetService(Bundle bundle, ServiceRegistration<EndpointEventListener> registration, EndpointEventListener service) {
                ProxyEndpointEventListener peel;
                ProxyEndpointEventListener proxyEndpointEventListener = peel = service instanceof ProxyEndpointEventListener ? (ProxyEndpointEventListener)service : null;
                if (peel == null) {
                    return;
                }
                Map map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List endpointEventHolders = (List)TopologyManager.this.bundleEndpointEventListenerMap.get(bundle);
                    if (endpointEventHolders != null) {
                        for (EndpointEventHolder eh : endpointEventHolders) {
                            peel.deliverRemoveEventForBundle(eh);
                        }
                    }
                }
            }
        }, props);
        String exportRegisteredSvcsFilter = (String)properties.get("exportRegisteredServicesFilter");
        if (exportRegisteredSvcsFilter == null) {
            exportRegisteredSvcsFilter = EXPORT_REGISTERED_SERVICES_FILTER;
        }
        this.topologyManagerImpl.exportRegisteredServices(exportRegisteredSvcsFilter);
    }

    protected Dictionary<String, Object> createEndpointListenerProps(List<String> filters) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("endpoint.listener.scope", this.matchingFilters.toArray(new String[filters.size()]));
        return props;
    }

    protected void deactivate() {
        if (this.endpointListenerRegistration != null) {
            this.endpointListenerRegistration.unregister();
            this.endpointListenerRegistration = null;
        }
        if (this.topologyManagerImpl != null) {
            this.topologyManagerImpl.close();
            this.topologyManagerImpl = null;
        }
        if (this.matchingFilters != null) {
            this.matchingFilters.clear();
            this.matchingFilters = null;
        }
    }

    public void remoteAdminEvent(RemoteServiceAdminEvent event) {
        if (this.topologyManagerImpl == null) {
            return;
        }
        this.topologyManagerImpl.handleRemoteAdminEvent(event);
    }

    public void event(ServiceEvent event, Map listeners) {
        if (this.topologyManagerImpl == null) {
            return;
        }
        this.topologyManagerImpl.handleEvent(event, listeners);
    }

    @Override
    public String[] getEndpointFilters() {
        return this.matchingFilters.toArray(new String[this.matchingFilters.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] setEndpointFilters(String[] newFilters) {
        List<String> f = this.matchingFilters;
        if (f == null || newFilters == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(f);
        List<String> list = f;
        synchronized (list) {
            f.clear();
            int i = 0;
            while (i < newFilters.length) {
                f.add(newFilters[i]);
                ++i;
            }
        }
        if (this.endpointListenerRegistration != null) {
            this.endpointListenerRegistration.setProperties(this.createEndpointListenerProps(Arrays.asList(newFilters)));
        }
        return result.toArray(new String[result.size()]);
    }

    class EndpointEventHolder {
        private final EndpointDescription endpointDescription;
        private final String filter;

        public EndpointEventHolder(EndpointDescription d, String f) {
            this.endpointDescription = d;
            this.filter = f;
        }

        public EndpointDescription getEndpoint() {
            return this.endpointDescription;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    class ProxyEndpointEventListener
    implements EndpointEventListener {
        private final Bundle bundle;

        public ProxyEndpointEventListener(Bundle b) {
            this.bundle = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endpointChanged(EndpointEvent event, String filter) {
            int type = event.getType();
            if (type == 1) {
                Map map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    ArrayList<EndpointEventHolder> endpointEventHolders = (ArrayList<EndpointEventHolder>)TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders == null) {
                        endpointEventHolders = new ArrayList<EndpointEventHolder>();
                    }
                    endpointEventHolders.add(new EndpointEventHolder(event.getEndpoint(), filter));
                    TopologyManager.this.bundleEndpointEventListenerMap.put(this.bundle, endpointEventHolders);
                }
            }
            if (type == 2) {
                Map map = TopologyManager.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List endpointEventHolders = (List)TopologyManager.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders != null) {
                        Iterator i = endpointEventHolders.iterator();
                        while (i.hasNext()) {
                            EndpointDescription newEd;
                            EndpointEventHolder eh = (EndpointEventHolder)i.next();
                            EndpointDescription oldEd = eh.getEndpoint();
                            if (!oldEd.equals((Object)(newEd = event.getEndpoint()))) continue;
                            i.remove();
                        }
                        if (endpointEventHolders.size() == 0) {
                            TopologyManager.this.bundleEndpointEventListenerMap.remove(this.bundle);
                        }
                    }
                }
            }
            this.deliverSafe(event, filter);
        }

        private void logError(String methodName, String message, Throwable e) {
            LogUtility.logError(methodName == null ? "<unknown>" : methodName, "org.eclipse.ecf.osgi.services.remoteserviceadmin/debug/topologymanager", TopologyManager.class, message == null ? "<empty>" : message, e);
        }

        private void deliverSafe(final EndpointEvent endpointEvent, final String matchingFilter) {
            final TopologyManagerImpl listener = TopologyManager.this.topologyManagerImpl;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (listener != null) {
                        listener.endpointChanged(endpointEvent, matchingFilter);
                    }
                }

                public void handleException(Throwable exception) {
                    String message = "Exception in EndpointEventListener listener=" + listener + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                    ProxyEndpointEventListener.this.logError("deliverSafe", message, exception);
                }
            });
        }

        public void deliverRemoveEventForBundle(EndpointEventHolder eventHolder) {
            this.deliverSafe(new EndpointEvent(2, eventHolder.getEndpoint()), eventHolder.getFilter());
        }
    }
}

