/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.harness.CoreTest;

public class FileSystemHelper {
    protected static int nextLocationCounter = 0;
    private static final long MASK = 0xFFFFFFFFL;

    public static IPath getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        try {
            tempPath = new File(tempPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        return new Path(tempPath);
    }

    public static IPath getRandomLocation(IPath parent) {
        IPath path = FileSystemHelper.computeRandomLocation(parent);
        while (path.toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            path = FileSystemHelper.computeRandomLocation(parent);
        }
        return path;
    }

    public static IPath computeRandomLocation(IPath parent) {
        long segment = (long)(++nextLocationCounter) << 32 | System.currentTimeMillis() & 0xFFFFFFFFL;
        return parent.append(Long.toString(segment));
    }

    public static void clear(File file) {
        String[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.list()) != null) {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                FileSystemHelper.clear(new File(file, child));
                ++n2;
            }
        }
        if (!file.delete()) {
            String message = "ensureDoesNotExistInFileSystem(File) could not delete: " + file.getPath();
            CoreTest.log("org.eclipse.core.tests.harness", (IStatus)new Status(2, "org.eclipse.core.tests.harness", 0, message, null));
        }
    }
}

