/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.pinclone;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.IPinProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.WorkbenchPart;

public class PinCloneUtils {
    public static String PIN_CLONE_VIEW_TAG = "PIN_CLONE_VIEW_";
    private static final DefaultPinElementColorDescriptor DEFAULT_PIN_ELEMENT_COLOR_DESCRIPTOR = new DefaultPinElementColorDescriptor();

    public static IPinProvider.IPinElementColorDescriptor getDefaultPinElementColorDescriptor() {
        return DEFAULT_PIN_ELEMENT_COLOR_DESCRIPTOR;
    }

    public static String encodeClonedPartSecondaryId(String secondaryId) {
        return String.valueOf(PIN_CLONE_VIEW_TAG) + secondaryId;
    }

    public static String decodeClonedPartSecondaryId(String secondaryId) {
        if (secondaryId == null) {
            return "";
        }
        return secondaryId.replaceFirst(PIN_CLONE_VIEW_TAG, "");
    }

    public static boolean isClonedPart(IViewPart part) {
        String secondaryId = part.getViewSite().getSecondaryId();
        return PinCloneUtils.hasCloneTag(secondaryId);
    }

    public static boolean isClonedPart(IViewReference ref) {
        String secondaryId = ref.getSecondaryId();
        return PinCloneUtils.hasCloneTag(secondaryId);
    }

    private static boolean hasCloneTag(String id) {
        return id != null && id.startsWith(PIN_CLONE_VIEW_TAG);
    }

    public static void setPartTitle(IViewPart part) {
        try {
            String tag;
            String name;
            if (!PinCloneUtils.isClonedPart(part)) {
                return;
            }
            String secondaryId = part.getViewSite().getSecondaryId();
            secondaryId = PinCloneUtils.decodeClonedPartSecondaryId(secondaryId);
            Method method = WorkbenchPart.class.getDeclaredMethod("setPartName", String.class);
            if (method != null && part instanceof WorkbenchPart && !(name = ((WorkbenchPart)part).getPartName()).contains(tag = " <" + secondaryId + ">")) {
                name = String.valueOf(name) + tag;
                method.setAccessible(true);
                method.invoke((Object)part, name);
            }
        }
        catch (Exception e) {
            CDebugUIPlugin.log(e);
        }
    }

    public static void setPartContentDescription(IViewPart part, String description) {
        try {
            Method method = WorkbenchPart.class.getDeclaredMethod("setContentDescription", String.class);
            if (method != null) {
                method.setAccessible(true);
                method.invoke((Object)part, description);
            }
        }
        catch (Exception e) {
            CDebugUIPlugin.log(e);
        }
    }

    public static boolean isPinnable(IWorkbenchPart part, ISelection selection) {
        boolean pinnable = false;
        if (selection instanceof IStructuredSelection) {
            List list = ((IStructuredSelection)selection).toList();
            for (Object element : list) {
                IPinProvider pinProvider;
                pinnable = false;
                if (element instanceof IAdaptable && (pinProvider = (IPinProvider)((IAdaptable)element).getAdapter(IPinProvider.class)) != null && pinProvider.isPinnable(part, element)) {
                    pinnable = true;
                }
                if (!pinnable) break;
            }
        }
        return pinnable;
    }

    public static IPinProvider.IPinElementColorDescriptor getPinElementColorDescriptor(Set<IPinProvider.IPinElementHandle> handles, Object debugContext) {
        int color = -1;
        IPinProvider.IPinElementColorDescriptor colorDesc = null;
        for (IPinProvider.IPinElementHandle handle : handles) {
            IPinProvider pinProvider;
            if (!(debugContext instanceof IAdaptable) || (pinProvider = (IPinProvider)((IAdaptable)debugContext).getAdapter(IPinProvider.class)) == null || !pinProvider.isPinnedTo(debugContext, handle) || (colorDesc = handle.getPinElementColorDescriptor()) == null) continue;
            int overlayColor = colorDesc.getOverlayColor();
            if (color == -1) {
                color = overlayColor;
            }
            if (color == overlayColor) continue;
            colorDesc = null;
            break;
        }
        if (colorDesc == null) {
            colorDesc = PinCloneUtils.getDefaultPinElementColorDescriptor();
        }
        return colorDesc;
    }

    public static boolean isPinnedTo(Set<IPinProvider.IPinElementHandle> handles, Object debugContext) {
        for (IPinProvider.IPinElementHandle handle : handles) {
            IPinProvider pinProvider;
            if (!(debugContext instanceof IAdaptable) || (pinProvider = (IPinProvider)((IAdaptable)debugContext).getAdapter(IPinProvider.class)) == null || !pinProvider.isPinnedTo(debugContext, handle)) continue;
            return true;
        }
        return false;
    }

    private static class DefaultPinElementColorDescriptor
    implements IPinProvider.IPinElementColorDescriptor {
        private DefaultPinElementColorDescriptor() {
        }

        @Override
        public int getOverlayColor() {
            return 0;
        }

        @Override
        public ImageDescriptor getToolbarIconDescriptor() {
            return null;
        }
    }
}

