/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.providers;

import org.eclipse.bpmn2.modeler.ui.property.providers.TreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDElementDeclarationTreeNode;
import org.eclipse.bpmn2.modeler.ui.property.providers.XSDTypeDefinitionTreeNode;
import org.eclipse.wst.wsdl.Part;

public class PartTreeNode
extends TreeNode {
    XSDTypeDefinitionTreeNode xsdType;
    XSDElementDeclarationTreeNode xsdElement;
    boolean displayParticles;

    public PartTreeNode(Part part, boolean isCondensed) {
        this(part, isCondensed, true);
    }

    public PartTreeNode(Part part, boolean isCondensed, boolean displayParticles) {
        super(part, isCondensed);
        if (part.getTypeDefinition() != null) {
            this.xsdType = new XSDTypeDefinitionTreeNode(part.getTypeDefinition(), false);
        } else if (part.getElementDeclaration() != null) {
            this.xsdElement = new XSDElementDeclarationTreeNode(part.getElementDeclaration(), false);
        }
        this.displayParticles = displayParticles;
    }

    @Override
    public String getLabelSuffix() {
        if (this.xsdType != null) {
            String label = this.xsdType.getLabel();
            return label;
        }
        if (this.xsdElement != null) {
            String label = this.xsdElement.getLabel();
            return label;
        }
        return null;
    }

    @Override
    public Object[] getChildren() {
        if (this.xsdType != null && this.displayParticles) {
            return this.xsdType.getChildren();
        }
        if (this.xsdElement != null && this.displayParticles) {
            return this.xsdElement.getChildren();
        }
        return EMPTY_ARRAY;
    }

    @Override
    public boolean hasChildren() {
        if (this.xsdType != null && this.displayParticles) {
            return this.xsdType.hasChildren();
        }
        if (this.xsdElement != null && this.displayParticles) {
            return this.xsdElement.hasChildren();
        }
        return false;
    }

    @Override
    public String getLabel() {
        String label = super.getLabel();
        return label;
    }
}

