/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.factories;

import org.eclipse.bpel.ui.Policy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractUIObjectFactory
implements CreationFactory {
    protected String idString;

    protected String createUniqueIdString() {
        StringBuffer s = new StringBuffer(this.getModelType().getEPackage().getNsURI());
        int i = s.indexOf(":");
        while (i >= 0) {
            s.delete(0, i + 1);
            i = s.indexOf(":");
        }
        while (s.length() > 0 && s.charAt(0) == '/') {
            s.deleteCharAt(0);
        }
        if (s.toString().endsWith(".ecore")) {
            s.setLength(s.length() - 5);
        }
        i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '/') {
                s.setCharAt(i, '.');
            }
            ++i;
        }
        if (s.length() > 0 && s.charAt(s.length() - 1) != '.') {
            s.append('.');
        }
        s.append(this.getModelType().getName());
        if (Policy.DEBUG) {
            System.out.println("uniqueIdString for " + this.getModelType().getName() + " is: " + s);
        }
        return s.toString();
    }

    public abstract EClass getModelType();

    public <T extends EObject> T createInstance() {
        EClass modelType = this.getModelType();
        return (T)modelType.getEPackage().getEFactoryInstance().create(modelType);
    }

    public abstract ImageDescriptor getSmallImageDescriptor();

    public abstract ImageDescriptor getLargeImageDescriptor();

    public abstract Image getSmallImage();

    public abstract Image getLargeImage();

    public abstract String getTypeLabel();

    public String getUniqueIdString() {
        if (this.idString == null) {
            this.idString = this.createUniqueIdString();
        }
        return this.idString;
    }

    public final Object getNewObject() {
        return this.createInstance();
    }

    public final Object getObjectType() {
        return this.getModelType();
    }
}

