/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Counter;

class PointValuesWriter {
    private final FieldInfo fieldInfo;
    private final ByteBlockPool bytes;
    private final Counter iwBytesUsed;
    private int[] docIDs;
    private int numPoints;
    private int numDocs;
    private int lastDocID = -1;
    private final byte[] packedValue;

    public PointValuesWriter(DocumentsWriterPerThread docWriter, FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = docWriter.bytesUsed;
        this.bytes = new ByteBlockPool(docWriter.byteBlockAllocator);
        this.docIDs = new int[16];
        this.iwBytesUsed.addAndGet(64L);
        this.packedValue = new byte[fieldInfo.getPointDimensionCount() * fieldInfo.getPointNumBytes()];
    }

    public void addPackedValue(int docID, BytesRef value) {
        if (value == null) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": point value must not be null");
        }
        if (value.length != this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes()) {
            throw new IllegalArgumentException("field=" + this.fieldInfo.name + ": this field's value has length=" + value.length + " but should be " + this.fieldInfo.getPointDimensionCount() * this.fieldInfo.getPointNumBytes());
        }
        if (this.docIDs.length == this.numPoints) {
            this.docIDs = ArrayUtil.grow(this.docIDs, this.numPoints + 1);
            this.iwBytesUsed.addAndGet((this.docIDs.length - this.numPoints) * 4);
        }
        this.bytes.append(value);
        this.docIDs[this.numPoints] = docID;
        if (docID != this.lastDocID) {
            ++this.numDocs;
            this.lastDocID = docID;
        }
        ++this.numPoints;
    }

    public void flush(SegmentWriteState state, PointsWriter writer) throws IOException {
        writer.writeField(this.fieldInfo, new PointsReader(){

            @Override
            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                if (!fieldName.equals(((PointValuesWriter)PointValuesWriter.this).fieldInfo.name)) {
                    throw new IllegalArgumentException("fieldName must be the same");
                }
                for (int i = 0; i < PointValuesWriter.this.numPoints; ++i) {
                    PointValuesWriter.this.bytes.readBytes(PointValuesWriter.this.packedValue.length * i, PointValuesWriter.this.packedValue, 0, PointValuesWriter.this.packedValue.length);
                    visitor.visit(PointValuesWriter.this.docIDs[i], PointValuesWriter.this.packedValue);
                }
            }

            @Override
            public void checkIntegrity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getNumDimensions(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getBytesPerDimension(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size(String fieldName) {
                return PointValuesWriter.this.numPoints;
            }

            @Override
            public int getDocCount(String fieldName) {
                return PointValuesWriter.this.numDocs;
            }
        });
    }
}

