/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.schema.sql;

import com.google.gwtorm.jdbc.gen.CodeGenSupport;
import com.google.gwtorm.schema.ColumnModel;
import com.google.gwtorm.schema.sql.SqlDialect;
import com.google.gwtorm.schema.sql.SqlTypeInfo;
import org.objectweb.asm.Type;

public class SqlCharTypeInfo
extends SqlTypeInfo {
    @Override
    public String getSqlType(ColumnModel column, SqlDialect dialect) {
        StringBuilder r = new StringBuilder();
        r.append("CHAR(1)");
        if (column.isNotNull()) {
            r.append(" DEFAULT ' '");
            r.append(" NOT NULL");
        }
        return r.toString();
    }

    @Override
    protected String getJavaSqlTypeAlias() {
        return "String";
    }

    @Override
    protected int getSqlTypeConstant() {
        return 1;
    }

    @Override
    public void generatePreparedStatementSet(CodeGenSupport cgs) {
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.pushFieldValue();
        cgs.mv.visitMethodInsn(184, Type.getInternalName(Character.class), "toString", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[]{Type.CHAR_TYPE}));
        cgs.invokePreparedStatementSet(this.getJavaSqlTypeAlias());
    }

    @Override
    public void generateResultSetGet(CodeGenSupport cgs) {
        cgs.fieldSetBegin();
        cgs.pushSqlHandle();
        cgs.pushColumnIndex();
        cgs.invokeResultSetGet(this.getJavaSqlTypeAlias());
        cgs.push(0);
        cgs.mv.visitMethodInsn(182, Type.getInternalName(String.class), "charAt", Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[]{Type.INT_TYPE}));
        cgs.fieldSetEnd();
    }
}

