'use strict';
const type_1 = require("../type");
const ast = require("../yamlAST");
function resolveYamlNull(nodeOrString) {
    const nullValue = ast.isYAMLNode(nodeOrString) ? nodeOrString.value : nodeOrString;
    if (null === nullValue) {
        return true;
    }
    var max = nullValue.length;
    return (max === 1 && nullValue === '~') ||
        (max === 4 && (nullValue === 'null' || nullValue === 'Null' || nullValue === 'NULL'));
}
function constructYamlNull(nodeOrString) {
    if (ast.isYAMLNode(nodeOrString)) {
        return nodeOrString;
    }
    return null;
}
function isNull(object) {
    return null === object;
}
module.exports = new type_1.Type('tag:yaml.org,2002:null', {
    kind: 'scalar',
    resolve: resolveYamlNull,
    construct: constructYamlNull,
    predicate: isNull,
    represent: {
        canonical: function () { return '~'; },
        lowercase: function () { return 'null'; },
        uppercase: function () { return 'NULL'; },
        camelcase: function () { return 'Null'; }
    },
    defaultStyle: 'lowercase'
});
//# sourceMappingURL=null.js.map