/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.helper.task.operations;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.helper.task.IModificationTask;
import org.eclipse.sirius.business.internal.helper.task.operations.AbstractOperationTask;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.tool.MoveElement;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class MoveElementTask
extends AbstractOperationTask
implements IModificationTask {
    private final MoveElement op;
    private final RuntimeLoggerInterpreter safeInterpreter;
    private EObject container;
    private EObject element;

    public MoveElementTask(CommandContext context, ModelAccessor extPackage, MoveElement op, IInterpreter interpreter) {
        super(context, extPackage, interpreter);
        this.op = op;
        this.safeInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
    }

    @Override
    public void execute() {
        this.element = this.getElement();
        this.container = this.getContainer();
        String featureName = this.getFeatureName(this.element, this.op, this.op.getFeatureName());
        try {
            Object value;
            if (!this.extPackage.eIsMany(this.container, featureName) && (value = this.extPackage.eGet(this.container, featureName)) != null) {
                SiriusPlugin.getDefault().error(MessageFormat.format(Messages.MoveElementTask_ImpossibleToAddValueErrorMsg, featureName, this.container), new RuntimeException());
                return;
            }
            this.extPackage.eAdd(this.container, featureName, (Object)this.element);
        }
        catch (FeatureNotFoundException e) {
            RuntimeLoggerManager.INSTANCE.error((EObject)this.op, (EStructuralFeature)ToolPackage.eINSTANCE.getMoveElement_FeatureName(), e);
        }
    }

    @Override
    public String getLabel() {
        return Messages.MoveElementTask_label;
    }

    private EObject getElement() {
        return this.context.getCurrentTarget();
    }

    private EObject getContainer() {
        return this.safeInterpreter.evaluateEObject(this.context.getCurrentTarget(), this.op, (EStructuralFeature)ToolPackage.eINSTANCE.getMoveElement_NewContainerExpression());
    }

    @Override
    public Collection<EObject> getAffectedElements() {
        return Collections.singleton(this.container);
    }

    @Override
    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }
}

