/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.analysis.loops.ASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.parser.ASTAssignStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignedGotoStmtNode;
import org.eclipse.photran.internal.core.parser.ASTAssignmentStmtNode;
import org.eclipse.photran.internal.core.parser.ASTCaseConstructNode;
import org.eclipse.photran.internal.core.parser.ASTNameNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IActionStmt;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class RemoveAssignedGotoRefactoring
extends FortranResourceRefactoring {
    protected boolean isDefaultCaseRequired = true;

    @Override
    public String getName() {
        return Messages.RemoveAssignedGoToRefactoring_Name;
    }

    public void setDefaultSelected(boolean isDefaultCaseRequired) {
        this.isDefaultCaseRequired = isDefaultCaseRequired;
    }

    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
        FileInfoFactory.reset();
        try {
            this.checkFilesForAssign(status);
        }
        catch (VPGRefactoring.PreconditionFailure pre) {
            FileInfoFactory.reset();
            status.addError(pre.getMessage());
            throw pre;
        }
    }

    protected void checkFilesForAssign(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        for (IFile file : this.selectedFiles) {
            FileInfo newInstance = FileInfoFactory.getInstance(file, (PhotranVPG)this.vpg);
            if (!newInstance.getAssignedStmtList().isEmpty()) continue;
            throw new VPGRefactoring.PreconditionFailure(Messages.bind((String)Messages.RemoveAssignedGotoRefactoring_NothingToBeRefactored, (Object)file.getFullPath()));
        }
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        for (IFile file : this.selectedFiles) {
            FileInfo data = FileInfoFactory.getInstance(file, (PhotranVPG)this.vpg);
            String removedVariables = data.removeVariablesUsedInActionStmt();
            if (data.getAssignedStmtList().isEmpty()) {
                FileInfoFactory.reset();
                throw new VPGRefactoring.PreconditionFailure(String.valueOf(Messages.RemoveAssignedGotoRefactoring_AllLabelsUsedInActionStatement) + file.getFullPath());
            }
            if (removedVariables.length() == 0) continue;
            status.addWarning(new StringBuffer(Messages.RemoveAssignedGotoRefactoring_TheFollowingLabelsCannotBeRefactored).append(removedVariables).append(Messages.RemoveAssignedGotoRefactoring_ForFile).append(file.getFullPath()).toString());
        }
    }

    private ASTCaseConstructNode createSelectCaseConstruct(ASTAssignedGotoStmtNode assignedGotoNode, FileInfo data) {
        String caseConstructString = "";
        String defaultCaseString = "";
        String endSelectString = "end select";
        String caseBodyString = this.createSelectCaseBody(assignedGotoNode, data);
        if (caseBodyString.length() == 0) {
            return null;
        }
        if (this.isDefaultCaseRequired) {
            defaultCaseString = "case default; stop \"Unknown label\"\n";
        }
        String selCaseString = "select case (" + assignedGotoNode.getVariableName().getText() + ")";
        caseConstructString = String.valueOf(selCaseString) + "\n" + caseBodyString + defaultCaseString + endSelectString + "\n";
        ASTCaseConstructNode caseStmt = (ASTCaseConstructNode)RemoveAssignedGotoRefactoring.parseLiteralStatement(caseConstructString);
        return caseStmt;
    }

    private String createSelectCaseBody(ASTAssignedGotoStmtNode assignedGotoNode, FileInfo data) {
        String caseBodyString = "";
        List<ASTAssignStmtNode> list = data.getAssignedStmtList();
        for (ASTAssignStmtNode assignNode : list) {
            if (!assignNode.getVariableName().getText().equals(assignedGotoNode.getVariableName().getText())) continue;
            caseBodyString = String.valueOf(caseBodyString) + "case (" + assignNode.getAssignedLblRef().getLabel().getText() + "); ";
            caseBodyString = String.valueOf(caseBodyString) + "goto " + assignNode.getAssignedLblRef().getLabel().getText() + "\n";
        }
        return caseBodyString;
    }

    private void makeChangesTo(IFile fileInEditor, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        if (ast == null) {
            return;
        }
        FileInfo data = FileInfoFactory.getInstance(fileInEditor, (PhotranVPG)this.vpg);
        List<ASTAssignStmtNode> list = data.getAssignedStmtList();
        for (ASTAssignStmtNode assignStmtNode : list) {
            this.replaceAssignedWithAssignment(ast, assignStmtNode);
        }
        data.sortAssignedStmtList();
        data.removeDuplicateAssigns();
        List<ASTAssignedGotoStmtNode> assignedGotoList = data.getAssignedGotoStmtList();
        for (ASTAssignedGotoStmtNode assignedGotoNode : assignedGotoList) {
            ASTCaseConstructNode caseConstructNode = this.createSelectCaseConstruct(assignedGotoNode, data);
            if (caseConstructNode == null) continue;
            caseConstructNode.getSelectCaseStmt().setLabel(assignedGotoNode.getLabel());
            this.copyCommentsFromOldNode(assignedGotoNode, caseConstructNode);
            assignedGotoNode.replaceWith(caseConstructNode);
            Reindenter.reindent(caseConstructNode, ast, Reindenter.Strategy.SHIFT_ENTIRE_BLOCK);
        }
        this.addChangeFromModifiedAST(fileInEditor, pm);
    }

    private void replaceAssignedWithAssignment(IFortranAST ast, ASTAssignStmtNode node) {
        String labelStr = node.getLabel() != null ? node.getLabel().getText() : "";
        String assignmentStr = String.valueOf(node.getVariableName().getText()) + " = " + node.getAssignedLblRef().getLabel().getText();
        ASTAssignmentStmtNode assignmentStmt = (ASTAssignmentStmtNode)RemoveAssignedGotoRefactoring.parseLiteralStatement(String.valueOf(labelStr) + assignmentStr);
        node.replaceWith(assignmentStmt);
        Reindenter.reindent(assignmentStmt.findFirstToken(), assignmentStmt.findLastToken(), ast);
        this.copyCommentsFromOldNode(node, assignmentStmt);
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        for (IFile file : this.selectedFiles) {
            IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
            try {
                this.makeChangesTo(file, ast, status, pm);
                FileInfoFactory.removeInstance(file);
            }
            catch (VPGRefactoring.PreconditionFailure e) {
                FileInfoFactory.reset();
                throw new OperationCanceledException(e.getMessage());
            }
        }
    }

    private void copyCommentsFromOldNode(IASTNode oldNode, IASTNode newNode) {
        newNode.findFirstToken().setWhiteBefore(oldNode.findFirstToken().getWhiteBefore());
        newNode.findLastToken().setWhiteBefore(oldNode.findLastToken().getWhiteBefore());
    }

    public PhotranVPG getVpg() {
        return (PhotranVPG)this.vpg;
    }

    public static class FileInfo {
        private List<ASTAssignStmtNode> assignedStmtList;
        private List<ASTAssignedGotoStmtNode> assignedGotoStmtList;
        private List<IActionStmt> actionStmtList;
        private boolean isVariableInActionStmt;
        private IFile file;
        private PhotranVPG vpg;
        private Set<String> labelAddresses;

        protected FileInfo(PhotranVPG vpg, IFile file) throws VPGRefactoring.PreconditionFailure {
            this.setVpg(vpg);
            this.setFile(file);
            this.assignedStmtList = new LinkedList<ASTAssignStmtNode>();
            this.assignedGotoStmtList = new LinkedList<ASTAssignedGotoStmtNode>();
            this.actionStmtList = new LinkedList<IActionStmt>();
            this.labelAddresses = new TreeSet<String>();
            this.initialize();
        }

        private void initialize() throws VPGRefactoring.PreconditionFailure {
            IFile file = this.getFile();
            IFortranAST ast = (IFortranAST)this.getVpg().acquirePermanentAST(file);
            if (ast == null) {
                throw new VPGRefactoring.PreconditionFailure(Messages.bind((String)Messages.RemoveAssignedGoToRefactoring_SelectedFileCannotBeParsed, (Object)file.getName()));
            }
            this.collectAllAssignedGoTos(ast.getRoot());
            this.ensureLabelAddressesArePresent(ast.getRoot());
        }

        public void cleanUp() {
            this.assignedStmtList.clear();
            this.assignedGotoStmtList.clear();
            this.actionStmtList.clear();
            this.isVariableInActionStmt = false;
            this.vpg.releaseAST(this.file);
        }

        public List<ASTAssignStmtNode> getAssignedStmtList() {
            return this.assignedStmtList;
        }

        public void setAssignedStmtList(List<ASTAssignStmtNode> assignedStmtList) {
            this.assignedStmtList = assignedStmtList;
        }

        public List<ASTAssignedGotoStmtNode> getAssignedGotoStmtList() {
            return this.assignedGotoStmtList;
        }

        public void setAssignedGotoStmtList(List<ASTAssignedGotoStmtNode> assignedGotoStmtList) {
            this.assignedGotoStmtList = assignedGotoStmtList;
        }

        public List<IActionStmt> getActionStmtList() {
            return this.actionStmtList;
        }

        public void setActionStmtList(List<IActionStmt> actionStmtList) {
            this.actionStmtList = actionStmtList;
        }

        public boolean isVariableInActionStmt() {
            return this.isVariableInActionStmt;
        }

        public void setVariableInActionStmt(boolean isVariableUsed) {
            this.isVariableInActionStmt = isVariableUsed;
        }

        public IFile getFile() {
            return this.file;
        }

        public void setFile(IFile file) {
            this.file = file;
        }

        public PhotranVPG getVpg() {
            return this.vpg;
        }

        public void setVpg(PhotranVPG vpg) {
            this.vpg = vpg;
        }

        private String removeVariablesUsedInActionStmt() {
            TreeSet<String> removedVariables = new TreeSet<String>();
            List<ASTAssignStmtNode> assignStmtList = this.getAssignedStmtList();
            int i = 0;
            while (i < assignStmtList.size()) {
                List<IActionStmt> actionStmtList = this.getActionStmtList();
                for (IActionStmt actionStmtNode : actionStmtList) {
                    String variable;
                    if (!this.doesActionStmtUseVariable(actionStmtNode, variable = assignStmtList.get(i).getVariableName().getText())) continue;
                    assignStmtList.remove(i);
                    removedVariables.add(variable);
                    --i;
                    break;
                }
                ++i;
            }
            String returnString = removedVariables.size() == 0 ? "" : ((Object)removedVariables).toString();
            return returnString;
        }

        private boolean doesActionStmtUseVariable(IActionStmt node, final String variable) {
            this.setVariableInActionStmt(false);
            node.accept(new ASTVisitorWithLoops(){

                @Override
                public void visitASTNameNode(ASTNameNode nameNode) {
                    if (nameNode.getName().getText().equalsIgnoreCase(variable)) {
                        FileInfo.this.setVariableInActionStmt(true);
                    }
                }
            });
            return this.isVariableInActionStmt();
        }

        private void sortAssignedStmtList() {
            int maxIndex = this.getAssignedStmtList().size();
            int i = 0;
            while (i < maxIndex) {
                int j = 0;
                while (j < maxIndex) {
                    String ref2;
                    ASTAssignStmtNode assignNode1 = this.getAssignedStmtList().get(i);
                    ASTAssignStmtNode assignNode2 = this.getAssignedStmtList().get(j);
                    String ref1 = assignNode1.getAssignedLblRef().getLabel().getText();
                    if (ref1.compareTo(ref2 = assignNode2.getAssignedLblRef().getLabel().getText()) < 0) {
                        ASTAssignStmtNode temp = assignNode1;
                        this.getAssignedStmtList().remove(assignNode1);
                        this.getAssignedStmtList().add(j, temp);
                    }
                    ++j;
                }
                ++i;
            }
        }

        private void removeDuplicateAssigns() {
            int maxIndex = this.getAssignedStmtList().size();
            int i = 0;
            while (i < maxIndex) {
                int j = i + 1;
                while (j < maxIndex) {
                    ASTAssignStmtNode assignNode1 = this.getAssignedStmtList().get(i);
                    ASTAssignStmtNode assignNode2 = this.getAssignedStmtList().get(j);
                    String ref1 = assignNode1.getAssignedLblRef().getLabel().getText();
                    String ref2 = assignNode2.getAssignedLblRef().getLabel().getText();
                    String var1 = assignNode1.getVariableName().getText();
                    String var2 = assignNode2.getVariableName().getText();
                    if (ref1.equals(ref2) && var1.equals(var2)) {
                        this.getAssignedStmtList().remove(j);
                        --maxIndex;
                        --j;
                    }
                    ++j;
                }
                ++i;
            }
        }

        private void ensureLabelAddressesArePresent(ScopingNode scope) throws VPGRefactoring.PreconditionFailure {
            scope.accept(new ASTVisitorWithLoops(){

                @Override
                public void visitIActionStmt(IActionStmt node) {
                    Token address = node.getLabel();
                    if (address instanceof Token) {
                        FileInfo.this.labelAddresses.remove(address.getText());
                    }
                    this.traverseChildren(node);
                }
            });
            if (this.labelAddresses.size() != 0) {
                throw new VPGRefactoring.PreconditionFailure(String.valueOf(Messages.RemoveAssignedGotoRefactoring_LabelNotFound) + this.file.getFullPath());
            }
        }

        private void collectAllAssignedGoTos(ScopingNode scope) {
            scope.accept(new ASTVisitorWithLoops(){

                @Override
                public void visitASTAssignStmtNode(ASTAssignStmtNode node) {
                    Token address = node.getAssignedLblRef().getLabel();
                    if (address instanceof Token) {
                        FileInfo.this.labelAddresses.add(address.getText());
                    }
                    FileInfo.this.getAssignedStmtList().add(0, node);
                    this.traverseChildren(node);
                }

                @Override
                public void visitASTAssignedGotoStmtNode(ASTAssignedGotoStmtNode node) {
                    FileInfo.this.getAssignedGotoStmtList().add(0, node);
                    this.traverseChildren(node);
                }

                @Override
                public void visitIActionStmt(IActionStmt node) {
                    if (!(node instanceof ASTAssignedGotoStmtNode) && !(node instanceof ASTAssignStmtNode)) {
                        FileInfo.this.getActionStmtList().add(0, node);
                        this.traverseChildren(node);
                    }
                }
            });
        }
    }

    public static class FileInfoFactory {
        private static final Map<IFile, FileInfo> store = new HashMap<IFile, FileInfo>();

        public static FileInfo getInstance(IFile file, PhotranVPG vpg) throws VPGRefactoring.PreconditionFailure {
            FileInfo storedInfo = store.get(file);
            if (storedInfo != null) {
                return storedInfo;
            }
            FileInfo newInstance = new FileInfo(vpg, file);
            store.put(file, newInstance);
            return newInstance;
        }

        public static void reset() {
            for (Map.Entry<IFile, FileInfo> entry : store.entrySet()) {
                entry.getValue().cleanUp();
            }
            store.clear();
        }

        public static void remove(FileInfo instance) {
            instance.cleanUp();
            store.remove(instance.getFile());
        }

        public static void removeInstance(IFile file) {
            FileInfo instance = store.get(file);
            FileInfoFactory.remove(instance);
        }
    }
}

