/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.net.connect;

import java.util.Arrays;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lic.internal.base.NamedData;

public final class Port
implements NamedData<Integer> {
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Optional<String> raw;
    private final int lazy;

    public Port(String[] sources, int lazy) {
        this.lazy = lazy;
        String prefix = String.format("-%s=", this.key());
        this.raw = Arrays.stream(sources).map(String::toLowerCase).filter(source -> source.startsWith(prefix)).map(source -> source.substring(prefix.length())).findAny();
    }

    public String key() {
        return "server.port";
    }

    public Optional<Integer> get() {
        return this.raw.map(this::parse).orElseGet(Optional::empty);
    }

    private Optional<Integer> defaultPort() {
        return Optional.of(this.lazy);
    }

    private Optional<Integer> parse(String port) {
        try {
            return Optional.of(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            this.log.error("failed: ", (Throwable)e);
            return this.defaultPort();
        }
    }
}

