/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.uml.alf.Expression;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.AppliedStereotypePropertyEditorUtil;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.appliedStereotypeProperty.AppliedStereotypePropertyPackage;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.appliedStereotypeProperty.AppliedStereotypePropertyRule;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.appliedStereotypeProperty.ExpressionValueRule;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.validation.AbstractAppliedStereotypePropertyJavaValidator;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.validation.Check;

public class AppliedStereotypePropertyJavaValidator
extends AbstractAppliedStereotypePropertyJavaValidator {
    protected static final String NOT_EXIST_DISPLAY = "This named element does not exist";
    public static final String NOT_EXIST = "AppliedStereotypeProperty.quickfix.NOT_EXIST";

    @Check
    public void checkAppliedStereotypePropertyRule_property(AppliedStereotypePropertyRule appliedStereotypePropertyRule) {
        AppliedStereotypeProperty contextElement;
        Expression valueSpecification;
        ExpressionValueRule expressionRoot;
        if (appliedStereotypePropertyRule.getValue() != null && (expressionRoot = appliedStereotypePropertyRule.getValue()).getExpression() != null && (valueSpecification = expressionRoot.getExpression()) != null && !this.canExpressionResolve(contextElement = (AppliedStereotypeProperty)ContextElementUtil.getContextElement((Resource)appliedStereotypePropertyRule.eResource()), valueSpecification)) {
            this.error(NOT_EXIST_DISPLAY, (EStructuralFeature)AppliedStereotypePropertyPackage.eINSTANCE.getAppliedStereotypePropertyRule_Value());
        }
    }

    private boolean canExpressionResolve(AppliedStereotypeProperty context, Expression specification) {
        boolean canResolve = false;
        Element scope = context.getBaseElement();
        Type type = context.getStereotypeProperty().getType();
        int upperBound = context.getStereotypeProperty().getUpper();
        if (AppliedStereotypePropertyEditorUtil.getLabel(context).equals("=null")) {
            canResolve = true;
        } else if (type != null) {
            List<Object> resolvedValues = null;
            if (type instanceof PrimitiveType) {
                resolvedValues = AppliedStereotypePropertyEditorUtil.resolvePrimitiveValue(specification);
            } else if (type instanceof Enumeration) {
                ArrayList<NamedElement> candidates = new ArrayList<NamedElement>((Collection<NamedElement>)((Enumeration)type).getMembers());
                candidates.removeAll((Collection<?>)((Enumeration)type).getImportedMembers());
                resolvedValues = AppliedStereotypePropertyEditorUtil.resolveEnumerationLiteralValue(specification, candidates);
            } else if (type instanceof Element) {
                resolvedValues = AppliedStereotypePropertyEditorUtil.resolveReferenceValue(specification, scope);
            }
            if (resolvedValues != null) {
                if (!resolvedValues.isEmpty()) {
                    if (upperBound == 1) {
                        if (upperBound == resolvedValues.size()) {
                            canResolve = true;
                        }
                    } else {
                        canResolve = true;
                    }
                }
            } else {
                canResolve = true;
            }
        }
        return canResolve;
    }
}

