/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.creation;

import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.InputDialog;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.widgets.Control;

public class StringEditionFactory
implements ReferenceValueFactory {
    private String title = Messages.StringEditionFactory_EnterANewValue;
    private String label = Messages.StringEditionFactory_EnterANewValue;
    private IInputValidator validator;
    private IStaticContentProvider contentProvider;

    public StringEditionFactory() {
    }

    public StringEditionFactory(String title, String label) {
        this.title = title;
        this.label = label;
    }

    public StringEditionFactory(IInputValidator validator) {
        this.validator = validator;
    }

    public StringEditionFactory(String title, String label, IInputValidator validator) {
        this.title = title;
        this.label = label;
        this.validator = validator;
    }

    @Override
    public boolean canCreateObject() {
        return true;
    }

    @Override
    public Object createObject(Control widget, Object context) {
        int result;
        InputDialog dialog = new InputDialog(widget.getShell(), this.title, this.label, "", this.validator);
        if (this.contentProvider != null) {
            dialog.setContentProvider(this.contentProvider);
        }
        if ((result = dialog.open()) == 0) {
            String newValue = dialog.getText();
            return newValue;
        }
        return null;
    }

    @Override
    public Collection<Object> validateObjects(Collection<Object> objectsToValidate) {
        return objectsToValidate;
    }

    @Override
    public boolean canEdit() {
        return true;
    }

    @Override
    public Object edit(Control widget, Object object) {
        int result;
        if (!(object instanceof String)) {
            return object;
        }
        InputDialog dialog = new InputDialog(widget.getShell(), this.title, this.label, (String)object, this.validator);
        if (this.contentProvider != null) {
            dialog.setContentProvider(this.contentProvider);
        }
        if ((result = dialog.open()) == 0) {
            String newValue = dialog.getText();
            return newValue;
        }
        return object;
    }

    public void setValidator(IInputValidator validator) {
        this.validator = validator;
    }

    public void setContentProvider(IStaticContentProvider provider) {
        this.contentProvider = provider;
    }
}

