/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.AbstractIterator;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.log.Log;

public class RollingLog
extends Worker
implements Log,
Iterable<LogLine> {
    private static final String PROP_FILE_NUMBER = "RollingLog.fileNumber";
    private static final String PROP_LOG_LINE_COUNTER = "RollingLog.logLineCounter";
    private final String logFile;
    private final long logSize;
    private final AtomicLong logLineCounter = new AtomicLong(0L);
    private final AtomicLong lastWrittenID = new AtomicLong(-1L);
    private int fileNumber;
    private boolean fileAppend;
    private long writeInterval = 100L;
    private boolean writeBulk = true;
    private List<LogLine> queue = new ArrayList<LogLine>();

    public RollingLog(String logFile, long logSize, boolean append) {
        this.logFile = logFile;
        this.logSize = logSize;
        this.fileAppend = append;
        this.setDaemon(true);
    }

    public final String getLogFile() {
        return this.logFile;
    }

    public final long getLogSize() {
        return this.logSize;
    }

    public final long getLogLineCounter() {
        return this.logLineCounter.get();
    }

    public final int getFileNumber() {
        return this.fileNumber;
    }

    public long getWriteInterval() {
        return this.writeInterval;
    }

    public void setWriteInterval(long writeInterval) {
        this.writeInterval = writeInterval;
    }

    public boolean isWriteBulk() {
        return this.writeBulk;
    }

    public void setWriteBulk(boolean writeBulk) {
        this.writeBulk = writeBulk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void log(String message) {
        LogLine logLine = this.createLogLine(message);
        RollingLog rollingLog = this;
        synchronized (rollingLog) {
            logLine.id = this.logLineCounter.incrementAndGet();
            this.queue.add(logLine);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws InterruptedException {
        long id;
        Object object = this;
        synchronized (object) {
            id = this.logLineCounter.get();
        }
        object = this.lastWrittenID;
        synchronized (object) {
            while (this.lastWrittenID.get() < id) {
                this.lastWrittenID.wait(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void work(Worker.WorkContext context) throws Exception {
        List<LogLine> logLines;
        RollingLog rollingLog = this;
        synchronized (rollingLog) {
            if (this.queue.isEmpty()) {
                try {
                    this.wait(this.writeInterval);
                }
                catch (InterruptedException ex) {
                    context.terminate();
                }
                context.nextWork();
            }
            if (this.writeBulk) {
                logLines = this.queue;
                this.queue = new ArrayList<LogLine>();
            } else {
                logLines = new ArrayList<LogLine>();
                logLines.add(this.queue.remove(0));
            }
        }
        long lastID = this.writeLogLines(logLines);
        if (lastID != -1L) {
            AtomicLong atomicLong = this.lastWrittenID;
            synchronized (atomicLong) {
                this.lastWrittenID.set(lastID);
                this.lastWrittenID.notifyAll();
            }
        }
    }

    protected LogLine createLogLine(String message) {
        long millis = System.currentTimeMillis();
        String thread = this.getThreadInfo();
        return new LogLine(millis, thread, message);
    }

    protected long writeLogLines(List<LogLine> logLines) {
        block6: {
            if (this.logFile != null) {
                long l;
                PrintStream out = null;
                try {
                    File file = this.getCurrentLogFile();
                    out = new PrintStream(new FileOutputStream(file, this.fileAppend));
                    l = this.writeLogLines(logLines, out);
                    this.fileAppend = true;
                }
                catch (IOException ex) {
                    OM.LOG.error(ex);
                    break block6;
                }
                finally {
                    this.fileAppend = true;
                    IOUtil.closeSilent(out);
                }
                IOUtil.closeSilent(out);
                return l;
            }
            return this.writeLogLines(logLines, System.out);
        }
        return -1L;
    }

    protected long writeLogLines(List<LogLine> logLines, PrintStream out) {
        long lastID = -1L;
        for (LogLine logLine : logLines) {
            this.writeLogLine(logLine, out);
            lastID = logLine.getID();
        }
        return lastID;
    }

    protected void writeLogLine(LogLine logLine, PrintStream out) {
        out.println(logLine);
    }

    protected String getThreadInfo() {
        return Thread.currentThread().getName();
    }

    @Override
    protected void doActivate() throws Exception {
        if (this.fileAppend) {
            File propertiesFile = this.getPropertiesFile();
            if (propertiesFile.isFile()) {
                this.load(propertiesFile);
                propertiesFile.delete();
            } else {
                this.init();
            }
        }
        super.doActivate();
        this.log("Log activated");
    }

    @Override
    protected void doDeactivate() throws Exception {
        this.log("Log deactivated");
        this.commit();
        File propertiesFile = this.getPropertiesFile();
        this.save(propertiesFile);
        super.doDeactivate();
    }

    protected void recovery(Properties properties, LogLine logLine) {
    }

    protected void load(Properties properties) {
    }

    protected void save(Properties properties) {
    }

    private int getLastFileNumber() {
        int lastFileNumber = -1;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            File file = RollingLog.getFile(this.logFile, i);
            if (!file.isFile()) break;
            lastFileNumber = i++;
        }
        return lastFileNumber;
    }

    private File getCurrentLogFile() {
        File file;
        while (true) {
            file = RollingLog.getFile(this.logFile, this.fileNumber);
            if (!this.fileAppend || file.length() <= this.logSize) break;
            this.fireEvent(new SplitEvent(this, file, this.fileNumber));
            ++this.fileNumber;
            this.fileAppend = false;
        }
        return file;
    }

    private File getPropertiesFile() {
        return new File(String.valueOf(this.getLogFile()) + ".properties");
    }

    private void init() {
        int number = this.getLastFileNumber();
        if (number == -1) {
            this.fileAppend = false;
        } else {
            this.recover(number);
        }
    }

    private void recover(int lastFileNumber) {
        Properties properties = new Properties();
        IListener[] listeners = this.getListeners();
        long lastID = 0L;
        LogIterator iterator = new LogIterator(this.logFile, lastFileNumber);
        while (iterator.hasNext()) {
            LogLine logLine = (LogLine)iterator.next();
            lastID = logLine.getID();
            this.recovery(properties, logLine);
            if (listeners == null) continue;
            this.fireEvent(new RecoveryEvent(this, properties, logLine), listeners);
        }
        this.logLineCounter.set(lastID);
        this.fileNumber = lastFileNumber;
        this.loadInternal(properties);
    }

    private void load(File file) throws IOException {
        String fileNumberStr;
        Properties properties = new Properties();
        try (FileInputStream in = new FileInputStream(file);){
            properties.load(in);
        }
        String logLineCounterStr = (String)properties.remove(PROP_LOG_LINE_COUNTER);
        if (logLineCounterStr != null) {
            this.logLineCounter.set(Long.parseLong(logLineCounterStr));
        }
        if ((fileNumberStr = (String)properties.remove(PROP_FILE_NUMBER)) != null) {
            this.fileNumber = Integer.parseInt(fileNumberStr);
        }
        this.loadInternal(properties);
    }

    private void loadInternal(Properties properties) {
        this.load(properties);
        this.fireEvent(new PropertiesEvent(this, PropertiesEvent.Type.LOAD, properties));
    }

    private void save(File file) throws IOException {
        Properties properties = new Properties();
        this.fireEvent(new PropertiesEvent(this, PropertiesEvent.Type.SAVE, properties));
        this.save(properties);
        this.saveInternal(properties);
        try (FileOutputStream out = new FileOutputStream(file);){
            properties.store(out, RollingLog.class.getSimpleName());
        }
    }

    private void saveInternal(Properties properties) {
        properties.setProperty(PROP_LOG_LINE_COUNTER, Long.toString(this.logLineCounter.get()));
        properties.setProperty(PROP_FILE_NUMBER, Integer.toString(this.fileNumber));
    }

    @Override
    public String toString() {
        return "RollingLog[" + this.logFile + "]";
    }

    @Override
    public final CloseableIterator<LogLine> iterator() {
        return RollingLog.iterator(this.logFile);
    }

    public static CloseableIterator<LogLine> iterator(String logFile) {
        return new LogIterator(logFile, 0);
    }

    public static void main(String[] args) {
        CloseableIterator<LogLine> it = RollingLog.iterator(args[0]);
        while (it.hasNext()) {
            LogLine logLine = (LogLine)it.next();
            System.out.println(logLine);
        }
    }

    private static File getFile(String logFile, int fileNumber) {
        return new File(String.valueOf(logFile) + String.format("-%04d", fileNumber) + ".txt");
    }

    private static final class LogIterator
    extends AbstractIterator<LogLine>
    implements CloseableIterator<LogLine> {
        private static final int CLOSED = -1;
        private final String logFile;
        private int fileNumber;
        private BufferedReader reader;

        public LogIterator(String logFile, int fileNumber) {
            this.logFile = logFile;
            this.fileNumber = fileNumber;
        }

        @Override
        protected Object computeNextElement() {
            if (this.fileNumber == -1) {
                return END_OF_DATA;
            }
            if (this.reader == null) {
                File file;
                if ((file = RollingLog.getFile(this.logFile, this.fileNumber++)).isFile()) {
                    try {
                        this.reader = new BufferedReader(new FileReader(file));
                    }
                    catch (FileNotFoundException ex) {
                        OM.LOG.error(ex);
                        return END_OF_DATA;
                    }
                } else {
                    return END_OF_DATA;
                }
            }
            try {
                String string = this.reader.readLine();
                if (string == null) {
                    this.reader.close();
                    this.reader = null;
                    return this.computeNextElement();
                }
                return new LogLine(string);
            }
            catch (IOException ex) {
                OM.LOG.error(ex);
                return END_OF_DATA;
            }
        }

        @Override
        public void close() {
            IOUtil.close(this.reader);
            this.reader = null;
            this.fileNumber = -1;
        }

        @Override
        public boolean isClosed() {
            return this.fileNumber == -1;
        }
    }

    public static final class LogLine {
        private static final String NL = "\n\r";
        private static final String TAB = "\t";
        private static final String TABNL = "\t\n\r";
        private long id;
        private final long millis;
        private final String thread;
        private final String message;

        public LogLine(long millis, String thread, String message) {
            this.millis = millis;
            this.thread = StringUtil.translate(thread, TABNL, "   ");
            this.message = StringUtil.translate(message, NL, "  ");
        }

        public LogLine(String string) {
            StringTokenizer tokenizer = new StringTokenizer(string, TAB);
            this.id = Long.parseLong(tokenizer.nextToken());
            this.millis = Long.parseLong(tokenizer.nextToken());
            this.thread = tokenizer.nextToken();
            this.message = tokenizer.nextToken("").substring(1);
        }

        public long getID() {
            return this.id;
        }

        public long getMillis() {
            return this.millis;
        }

        public String getThread() {
            return this.thread;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return String.valueOf(this.id) + TAB + this.millis + TAB + this.thread + TAB + this.message;
        }
    }

    public static final class PropertiesEvent
    extends RollingLogEvent {
        private static final long serialVersionUID = 1L;
        private final Type type;
        private final Properties properties;

        public PropertiesEvent(RollingLog rollingLog, Type type, Properties properties) {
            super(rollingLog);
            this.type = type;
            this.properties = properties;
        }

        public Type getType() {
            return this.type;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        protected String formatAdditionalParameters() {
            return "type=" + (Object)((Object)this.type) + ", properties=" + this.properties;
        }

        public static enum Type {
            LOAD,
            SAVE;

        }
    }

    public static final class RecoveryEvent
    extends RollingLogEvent {
        private static final long serialVersionUID = 1L;
        private final Properties properties;
        private final LogLine logLine;

        public RecoveryEvent(RollingLog rollingLog, Properties properties, LogLine logLine) {
            super(rollingLog);
            this.properties = properties;
            this.logLine = logLine;
        }

        public String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        public void setProperty(String key, String value) {
            this.properties.setProperty(key, value);
        }

        public LogLine getLogLine() {
            return this.logLine;
        }

        @Override
        protected String formatAdditionalParameters() {
            return "logLine=" + this.logLine;
        }
    }

    public static abstract class RollingLogEvent
    extends Event {
        private static final long serialVersionUID = 1L;

        public RollingLogEvent(RollingLog rollingLog) {
            super(rollingLog);
        }

        @Override
        public RollingLog getSource() {
            return (RollingLog)super.getSource();
        }
    }

    public static final class SplitEvent
    extends RollingLogEvent {
        private static final long serialVersionUID = 1L;
        private final File lastFile;
        private final int lastFileNumber;

        public SplitEvent(RollingLog rollingLog, File lastFile, int lastFileNumber) {
            super(rollingLog);
            this.lastFile = lastFile;
            this.lastFileNumber = lastFileNumber;
        }

        public File getLastFile() {
            return this.lastFile;
        }

        public int getLastFileNumber() {
            return this.lastFileNumber;
        }

        @Override
        protected String formatAdditionalParameters() {
            return "lastFile=" + this.lastFile + ", lastFileNumber=" + this.lastFileNumber;
        }
    }
}

