/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.cache;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.cache.CacheRegistration;
import org.eclipse.net4j.util.cache.ICache;
import org.eclipse.net4j.util.cache.ICacheMonitor;
import org.eclipse.net4j.util.cache.ICacheMonitorEvent;
import org.eclipse.net4j.util.cache.ICacheRegistration;
import org.eclipse.net4j.util.concurrent.Worker;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CacheMonitor
extends Worker
implements ICacheMonitor {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CacheMonitor.class);
    private static final long DEFAULT_PAUSE_GREEN = 60000L;
    private static final long DEFAULT_PAUSE_YELLOW = 5000L;
    private static final long DEFAULT_PAUSE_RED = 100L;
    private long pauseGREEN = 60000L;
    private long pauseYELLOW = 5000L;
    private long pauseRED = 100L;
    private ICacheMonitor.ConditionPolicy conditionPolicy;
    private ICacheMonitor.Condition condition;
    private Map<ICache, ICacheRegistration> registrations = new HashMap<ICache, ICacheRegistration>();

    public long getPauseGREEN() {
        return this.pauseGREEN;
    }

    public void setPauseGREEN(long pauseGREEN) {
        this.pauseGREEN = pauseGREEN;
    }

    public long getPauseYELLOW() {
        return this.pauseYELLOW;
    }

    public void setPauseYELLOW(long pauseYELLOW) {
        this.pauseYELLOW = pauseYELLOW;
    }

    public long getPauseRED() {
        return this.pauseRED;
    }

    public void setPauseRED(long pauseRED) {
        this.pauseRED = pauseRED;
    }

    @Override
    public ICacheMonitor.ConditionPolicy getConditionPolicy() {
        return this.conditionPolicy;
    }

    public void setConditionPolicy(ICacheMonitor.ConditionPolicy conditionPolicy) {
        this.conditionPolicy = conditionPolicy;
    }

    @Override
    public ICacheMonitor.Condition getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheRegistration[] getRegistrations() {
        Map<ICache, ICacheRegistration> map = this.registrations;
        synchronized (map) {
            return this.registrations.values().toArray(new ICacheRegistration[this.registrations.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheRegistration registerCache(ICache cache) {
        ICacheRegistration oldRegistration;
        if (TRACER.isEnabled()) {
            TRACER.trace("Registering cache " + cache);
        }
        CacheRegistration registration = new CacheRegistration(this, cache);
        Map<ICache, ICacheRegistration> map = this.registrations;
        synchronized (map) {
            oldRegistration = this.registrations.put(cache, registration);
        }
        if (oldRegistration != null) {
            oldRegistration.dispose();
        }
        return registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterCache(ICache cache) {
        ICacheRegistration registration;
        Map<ICache, ICacheRegistration> map = this.registrations;
        synchronized (map) {
            registration = this.registrations.remove(cache);
        }
        if (registration != null) {
            registration.dispose();
            if (TRACER.isEnabled()) {
                TRACER.trace("Deregistered cache " + cache);
            }
        }
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (this.conditionPolicy == null) {
            throw new IllegalStateException("conditionPolicy == null");
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        ICacheRegistration[] iCacheRegistrationArray = this.getRegistrations();
        int n = iCacheRegistrationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICacheRegistration registration = iCacheRegistrationArray[n2];
            registration.dispose();
            ++n2;
        }
        this.registrations.clear();
        super.doDeactivate();
    }

    @Override
    protected void work(Worker.WorkContext context) throws Exception {
        ICacheMonitor.Condition newCondition = this.conditionPolicy.getNewCondition(this.condition);
        this.setCondition(newCondition);
        switch (newCondition) {
            case GREEN: {
                context.nextWork(this.pauseGREEN);
                break;
            }
            case YELLOW: {
                context.nextWork(this.pauseYELLOW);
                break;
            }
            case RED: {
                this.handleConditionRED();
                context.nextWork(this.pauseRED);
            }
        }
    }

    protected void setCondition(ICacheMonitor.Condition newCondition) {
        if (newCondition == null) {
            throw new ImplementationError("newCondition == null");
        }
        ICacheMonitor.Condition oldCondition = this.condition;
        if (newCondition != oldCondition) {
            this.condition = newCondition;
            IListener[] listeners = this.getListeners();
            if (listeners != null) {
                this.fireEvent(new CacheMonitorEvent(oldCondition, newCondition), listeners);
            }
        }
    }

    protected void handleConditionRED() {
        OM.LOG.warn("CONDITION RED");
    }

    private final class CacheMonitorEvent
    extends Event
    implements ICacheMonitorEvent {
        private static final long serialVersionUID = 1L;
        private ICacheMonitor.Condition oldCondition;
        private ICacheMonitor.Condition newCondition;

        public CacheMonitorEvent(ICacheMonitor.Condition oldCondition, ICacheMonitor.Condition newCondition) {
            super(CacheMonitor.this);
            this.oldCondition = oldCondition;
            this.newCondition = newCondition;
        }

        @Override
        public ICacheMonitor getSource() {
            return (ICacheMonitor)super.getSource();
        }

        @Override
        public ICacheMonitor.Condition getOldCondition() {
            return this.oldCondition;
        }

        @Override
        public ICacheMonitor.Condition getNewCondition() {
            return this.newCondition;
        }
    }
}

