/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter.instructions;

import org.eclipse.nebula.widgets.richtext.painter.SpanElement;
import org.eclipse.nebula.widgets.richtext.painter.TagProcessingState;
import org.eclipse.nebula.widgets.richtext.painter.instructions.FontMetricsProvider;
import org.eclipse.nebula.widgets.richtext.painter.instructions.PaintInstruction;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class ResetSpanStylePaintInstruction
implements PaintInstruction,
FontMetricsProvider {
    private TagProcessingState state;
    private SpanElement span;

    public ResetSpanStylePaintInstruction(TagProcessingState state, SpanElement span) {
        this.state = state;
        this.span = span;
    }

    @Override
    public void paint(GC gc, Rectangle area) {
        for (SpanElement.SpanType st : this.span.types) {
            switch (st) {
                case COLOR: {
                    gc.setForeground(this.state.pollPreviousColor());
                    break;
                }
                case BG_COLOR: {
                    gc.setBackground(this.state.pollPreviousBgColor());
                    break;
                }
                case FONT: {
                    gc.setFont(this.state.pollPreviousFont());
                }
            }
        }
    }

    @Override
    public FontMetrics getFontMetrics(GC gc) {
        if (this.span.types.contains((Object)SpanElement.SpanType.FONT)) {
            gc.setFont(this.state.pollPreviousFont());
        }
        return gc.getFontMetrics();
    }
}

