/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;

public class ProjectClassLoader
extends URLClassLoader {
    private static Map<IJavaProject, ProjectClassLoader> loadersMap = new HashMap<IJavaProject, ProjectClassLoader>();

    ProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        this(JavaCore.create((IProject)project));
    }

    ProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        super(ProjectClassLoader.getProjectClassPath(javaProject), ProjectClassLoader.class.getClassLoader());
        loadersMap.put(javaProject, this);
    }

    static synchronized boolean isProjectClassLoaderExisting(IJavaProject javaProject) {
        return loadersMap.containsKey(javaProject);
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        return ProjectClassLoader.getProjectClassLoader(JavaCore.create((IProject)project));
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader == null) {
            loader = new ProjectClassLoader(javaProject);
        }
        return loader;
    }

    static synchronized void resetProjectClassLoader(IJavaProject javaProject) {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader != null) {
            try {
                Method closeMethod = loader.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke((Object)loader, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof IOException) {
                    QvtPlugin.error((Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadersMap.remove(javaProject);
        }
    }

    static synchronized void resetAllProjectClassLoaders() {
        for (IJavaProject javaProject : loadersMap.keySet()) {
            ProjectClassLoader.resetProjectClassLoader(javaProject);
        }
    }

    private static URL[] getProjectClassPath(IJavaProject javaProject) throws CoreException, MalformedURLException {
        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        String[] stringArray = classPathEntries;
        int n = classPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Path path = new Path(entry);
            URL url = path.toFile().toURI().toURL();
            urlList.add(url);
            ++n2;
        }
        return urlList.toArray(new URL[0]);
    }
}

