/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.ui.preferences;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIMessages;
import org.eclipse.jst.ws.internal.cxf.ui.CXFUIPlugin;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.AnnotationsComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.BlankRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.CXF20WSDL2JavaPreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.CXF21WSDL2JavaPreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSDLRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSRuntimePreferencesComposite;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.SpringConfigComposite;
import org.eclipse.jst.ws.internal.cxf.ui.wizards.CXFInstallWizard;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CXFRuntimePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ISelection previousInstall = new StructuredSelection();
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private CheckboxTableViewer cxfInstallations;
    private Button exportCXFClasspathContainerButton;
    private CXFContext context;
    private Java2WSDLRuntimePreferencesComposite java2WSDLRuntimePreferencesComposite;
    private Java2WSRuntimePreferencesComposite java2WSRuntimePreferencesComposite;
    private CXF20WSDL2JavaPreferencesComposite cxf20WSDL2JavaPreferencesComposite;
    private CXF21WSDL2JavaPreferencesComposite cxf21WSDL2JavaPreferencesComposite;
    private AnnotationsComposite annotationsComposite;
    private SpringConfigComposite springConfigComposite;
    private StackLayout java2WSStackLayout;
    private StackLayout wsdl2javaStackLayout;
    private StackLayout jaxwsStackLayout;
    private StackLayout springConfigStackLayout;
    private Composite java2WSPreferncesGroup;
    private Composite wsdl2JavaPreferencesGroup;
    private Composite jaxwsPreferencesGroup;
    private Composite springConfigPreferncesGroup;
    private Composite java2WSDLPreferencesComposite;
    private Composite java2WSPreferencesComposite;
    private Composite jaxwsPreferencesComposite;
    private Composite wsdl2Java20PreferencesComposite;
    private Composite wsdl2Java21PreferencesComposite;
    private Composite springPreferencesComposite;
    private BlankRuntimePreferencesComposite java2WSBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite wsdl2JavaBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite jaxwsBlankPreferencesComposite;
    private BlankRuntimePreferencesComposite springConfigBlankPreferencesComposite;
    private Image libraryImage = CXFUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.jst.ws.cxf.ui", (String)"icons/obj16/library_obj.gif").createImage();

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.context = CXFCorePlugin.getDefault().getJava2WSContext();
        Composite composite = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        composite.setLayout((Layout)mainLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        TabFolder cxfPreferenceTab = new TabFolder(composite, 0);
        gridData = new GridData(1808);
        cxfPreferenceTab.setLayoutData((Object)gridData);
        TabItem runtimeInstalLocationItem = new TabItem(cxfPreferenceTab, 0);
        runtimeInstalLocationItem.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_NAME);
        runtimeInstalLocationItem.setToolTipText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_TOOLTIP);
        Composite runtimeGroup = new Composite((Composite)cxfPreferenceTab, 0);
        runtimeInstalLocationItem.setControl((Control)runtimeGroup);
        runtimeGroup.setToolTipText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_RUNTIME_HOME_TAB_TOOLTIP);
        GridLayout runtimeLoactionlayout = new GridLayout();
        runtimeLoactionlayout.numColumns = 3;
        runtimeLoactionlayout.marginHeight = 10;
        runtimeGroup.setLayout((Layout)runtimeLoactionlayout);
        gridData = new GridData(1808);
        runtimeGroup.setLayoutData((Object)gridData);
        Label runtimeTabDescriptionLabel = new Label(runtimeGroup, 64);
        runtimeTabDescriptionLabel.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_DESCRIPTION_LABEL);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        gridData.widthHint = 300;
        runtimeTabDescriptionLabel.setLayoutData((Object)gridData);
        Table installTable = new Table(runtimeGroup, 67618);
        installTable.setLinesVisible(true);
        installTable.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        installTable.setLayout((Layout)tableLayout);
        this.cxfInstallations = new CheckboxTableViewer(installTable);
        this.cxfInstallations.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    CXFRuntimePreferencePage.this.setCheckedInstall(event.getElement());
                } else {
                    CXFRuntimePreferencePage.this.setCheckedInstall(null);
                }
            }
        });
        this.cxfInstallations.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                int noElements = selection.size();
                if (noElements > 1) {
                    CXFRuntimePreferencePage.this.editButton.setEnabled(false);
                } else {
                    CXFRuntimePreferencePage.this.editButton.setEnabled(true);
                }
                CXFRuntimePreferencePage.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
        TableViewerColumn versionViewerColumn = new TableViewerColumn((TableViewer)this.cxfInstallations, 16384);
        versionViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall install = (CXFInstall)element;
                    String version = install.getVersion().toString().trim();
                    return version;
                }
                return "";
            }

            public Image getImage(Object element) {
                if (element instanceof CXFInstall) {
                    return CXFRuntimePreferencePage.this.libraryImage;
                }
                return null;
            }
        });
        TableColumn versionColumn = versionViewerColumn.getColumn();
        versionColumn.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_VERSION_COLUMN_NAME);
        versionColumn.pack();
        ColumnWeightData columnWeightData = new ColumnWeightData(50, 50, true);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableViewerColumn locationViewerColumn = new TableViewerColumn((TableViewer)this.cxfInstallations, 16384);
        locationViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall install = (CXFInstall)element;
                    return install.getLocation().toString().trim();
                }
                return "";
            }
        });
        TableColumn locationColumn = locationViewerColumn.getColumn();
        locationColumn.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_LOCATION_COLUMN_NAME);
        locationColumn.pack();
        columnWeightData = new ColumnWeightData(50, 150, true);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableViewerColumn typeViewerColumn = new TableViewerColumn((TableViewer)this.cxfInstallations, 16384);
        typeViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof CXFInstall) {
                    CXFInstall install = (CXFInstall)element;
                    return install.getType().toString().trim();
                }
                return "";
            }
        });
        TableColumn typeColumn = typeViewerColumn.getColumn();
        typeColumn.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_TYPE_COLUMN_NAME);
        typeColumn.pack();
        columnWeightData = new ColumnWeightData(50, 100, true);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 5;
        this.cxfInstallations.getTable().setLayoutData((Object)gridData);
        this.cxfInstallations.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Collection) {
                    return ((Collection)inputElement).toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.cxfInstallations.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object obj1, Object obj2) {
                if (obj1 instanceof CXFInstall && obj2 instanceof CXFInstall) {
                    return ((CXFInstall)obj1).getVersion().toString().trim().compareTo(((CXFInstall)obj2).getVersion().toString().trim());
                }
                return super.compare(viewer, obj1, obj2);
            }
        });
        this.cxfInstallations.setInput(this.context.getInstallations().values());
        this.addButton = new Button(runtimeGroup, 0);
        this.addButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_ADD_BUTTON_LABEL);
        gridData = new GridData(4, 1, false, false);
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CXFInstallWizard installWizard = new CXFInstallWizard();
                WizardDialog dialog = new WizardDialog(CXFRuntimePreferencePage.this.getShell(), (IWizard)installWizard);
                if (dialog.open() == 0) {
                    CXFRuntimePreferencePage.this.cxfInstallations.refresh();
                }
            }
        });
        this.editButton = new Button(runtimeGroup, 0);
        this.editButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_EDIT_BUTTON_LABEL);
        gridData = new GridData(4, 1, false, false);
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CXFRuntimePreferencePage.this.cxfInstallations.getSelection();
                if (selection != null && selection.getFirstElement() instanceof CXFInstall) {
                    CXFRuntimePreferencePage.this.cxfInstallations.getCheckedElements();
                    String checkedVersion = CXFRuntimePreferencePage.this.getCheckedVersion();
                    CXFInstallWizard installWizard = new CXFInstallWizard((CXFInstall)selection.getFirstElement());
                    WizardDialog dialog = new WizardDialog(CXFRuntimePreferencePage.this.getShell(), (IWizard)installWizard);
                    if (dialog.open() == 0) {
                        CXFRuntimePreferencePage.this.cxfInstallations.refresh();
                        if (checkedVersion != null) {
                            CXFRuntimePreferencePage.this.setCheckedVersion(checkedVersion);
                        }
                    }
                }
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(runtimeGroup, 0);
        this.removeButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_REMOVE_BUTTON_LABEL);
        gridData = new GridData(4, 1, false, false);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CXFRuntimePreferencePage.this.cxfInstallations.getSelection();
                Iterator iter = selection.iterator();
                Map installations = CXFRuntimePreferencePage.this.context.getInstallations();
                while (iter.hasNext()) {
                    CXFInstall install = (CXFInstall)iter.next();
                    installations.remove(install.getVersion());
                }
                CXFRuntimePreferencePage.this.context.setInstallations(installations);
                CXFRuntimePreferencePage.this.cxfInstallations.refresh();
                if (CXFRuntimePreferencePage.this.cxfInstallations.getCheckedElements().length == 0) {
                    CXFRuntimePreferencePage.this.setCheckedInstall(null);
                }
            }
        });
        this.removeButton.setEnabled(false);
        Label paddingLabel = new Label(runtimeGroup, 0);
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        paddingLabel.setLayoutData((Object)gridData);
        this.exportCXFClasspathContainerButton = new Button(runtimeGroup, 32);
        this.exportCXFClasspathContainerButton.setText(CXFUIMessages.CXF_RUNTIME_PREFERENCE_PAGE_EXPORT_CXF_CLASSPATH_CONTAINER);
        this.exportCXFClasspathContainerButton.setSelection(this.context.isExportCXFClasspathContainer());
        this.exportCXFClasspathContainerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CXFRuntimePreferencePage.this.context.setExportCXFClasspathContainer(((Button)e.widget).getSelection());
            }
        });
        gridData = new GridData(4, 4, false, false);
        gridData.horizontalSpan = 3;
        this.exportCXFClasspathContainerButton.setLayoutData((Object)gridData);
        if (this.context.getDefaultRuntimeVersion().length() > 0) {
            this.exportCXFClasspathContainerButton.setEnabled(true);
        } else {
            this.exportCXFClasspathContainerButton.setEnabled(false);
        }
        TabItem java2WSTabItem = new TabItem(cxfPreferenceTab, 0);
        java2WSTabItem.setText(CXFUIMessages.JAVA2WS_PREFERENCES_TAB_NAME);
        java2WSTabItem.setToolTipText(CXFUIMessages.JAVA2WS_PREFERENCES_TAB_TOOLTIP);
        this.java2WSPreferncesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.java2WSStackLayout = new StackLayout();
        this.java2WSPreferncesGroup.setLayout((Layout)this.java2WSStackLayout);
        this.java2WSDLPreferencesComposite = new Composite(this.java2WSPreferncesGroup, 0);
        GridLayout java2WSGridLayout = new GridLayout(1, true);
        this.java2WSDLPreferencesComposite.setLayout((Layout)java2WSGridLayout);
        this.java2WSDLRuntimePreferencesComposite = new Java2WSDLRuntimePreferencesComposite(this.java2WSDLPreferencesComposite, 0, cxfPreferenceTab);
        this.java2WSDLRuntimePreferencesComposite.addControls();
        this.java2WSPreferencesComposite = new Composite(this.java2WSPreferncesGroup, 0);
        GridLayout java2WSDLGridLayout = new GridLayout(1, true);
        this.java2WSPreferencesComposite.setLayout((Layout)java2WSDLGridLayout);
        this.java2WSRuntimePreferencesComposite = new Java2WSRuntimePreferencesComposite(this.java2WSPreferencesComposite, 0, cxfPreferenceTab);
        this.java2WSRuntimePreferencesComposite.addControls();
        this.java2WSBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.java2WSPreferncesGroup, 0);
        java2WSTabItem.setControl((Control)this.java2WSPreferncesGroup);
        TabItem wsdl2JavaTabItem = new TabItem(cxfPreferenceTab, 0);
        wsdl2JavaTabItem.setText(CXFUIMessages.WSDL2JAVA_PREFERENCES_TAB_NAME);
        wsdl2JavaTabItem.setToolTipText(CXFUIMessages.WSDL2JAVA_PREFERENCES_TAB_TOOLTIP);
        this.wsdl2JavaPreferencesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.wsdl2javaStackLayout = new StackLayout();
        this.wsdl2JavaPreferencesGroup.setLayout((Layout)this.wsdl2javaStackLayout);
        this.wsdl2Java20PreferencesComposite = new Composite(this.wsdl2JavaPreferencesGroup, 0);
        GridLayout wsdl2Java20GridLayout = new GridLayout(1, true);
        this.wsdl2Java20PreferencesComposite.setLayout((Layout)wsdl2Java20GridLayout);
        this.cxf20WSDL2JavaPreferencesComposite = new CXF20WSDL2JavaPreferencesComposite(this.wsdl2Java20PreferencesComposite, 0);
        this.cxf20WSDL2JavaPreferencesComposite.addControls();
        this.wsdl2Java21PreferencesComposite = new Composite(this.wsdl2JavaPreferencesGroup, 0);
        GridLayout wsdl2Java21GridLayout = new GridLayout(1, true);
        this.wsdl2Java21PreferencesComposite.setLayout((Layout)wsdl2Java21GridLayout);
        this.cxf21WSDL2JavaPreferencesComposite = new CXF21WSDL2JavaPreferencesComposite(this.wsdl2Java21PreferencesComposite, 0);
        this.cxf21WSDL2JavaPreferencesComposite.addControls();
        this.wsdl2JavaBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.wsdl2JavaPreferencesGroup, 0);
        wsdl2JavaTabItem.setControl((Control)this.wsdl2JavaPreferencesGroup);
        TabItem annotationsTabItem = new TabItem(cxfPreferenceTab, 0);
        annotationsTabItem.setText(CXFUIMessages.ANNOTATIONS_PREFERENCES_TAB_NAME);
        annotationsTabItem.setToolTipText(CXFUIMessages.ANNOTATIONS_PREFERENCES_TAB_TOOLTIP);
        this.jaxwsPreferencesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.jaxwsStackLayout = new StackLayout();
        this.jaxwsPreferencesGroup.setLayout((Layout)this.jaxwsStackLayout);
        this.jaxwsPreferencesComposite = new Composite(this.jaxwsPreferencesGroup, 0);
        GridLayout jaxwsGridLayout = new GridLayout(1, true);
        this.jaxwsPreferencesComposite.setLayout((Layout)jaxwsGridLayout);
        this.annotationsComposite = new AnnotationsComposite(this.jaxwsPreferencesComposite, 4);
        this.jaxwsBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.jaxwsPreferencesGroup, 0);
        annotationsTabItem.setControl((Control)this.jaxwsPreferencesGroup);
        TabItem springConfigTabItem = new TabItem(cxfPreferenceTab, 0);
        springConfigTabItem.setText(CXFUIMessages.SPRING_CONFIG_PREFERENCES_TAB_NAME);
        springConfigTabItem.setToolTipText(CXFUIMessages.SPRING_CONFIG_PREFERENCES_TAB_TOOLTIP);
        this.springConfigPreferncesGroup = new Composite((Composite)cxfPreferenceTab, 0);
        this.springConfigStackLayout = new StackLayout();
        this.springConfigPreferncesGroup.setLayout((Layout)this.springConfigStackLayout);
        this.springPreferencesComposite = new Composite(this.springConfigPreferncesGroup, 0);
        GridLayout springGridLayout = new GridLayout(1, true);
        this.springPreferencesComposite.setLayout((Layout)springGridLayout);
        this.springConfigComposite = new SpringConfigComposite(this.springPreferencesComposite, 4);
        this.springConfigBlankPreferencesComposite = new BlankRuntimePreferencesComposite(this.springConfigPreferncesGroup, 0);
        springConfigTabItem.setControl((Control)this.springConfigPreferncesGroup);
        CXFInstall defaultInstall = this.getDefaultInstall();
        if (defaultInstall != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)defaultInstall));
        }
        this.handlePreferenceControls();
        composite.pack();
        return composite;
    }

    private CXFInstall getDefaultInstall() {
        Collection set = this.context.getInstallations().values();
        for (CXFInstall entry : set) {
            if (!entry.getVersion().toString().trim().equals(this.context.getDefaultRuntimeVersion())) continue;
            return entry;
        }
        return null;
    }

    private String getCheckedVersion() {
        Object[] checkedElements = this.cxfInstallations.getCheckedElements();
        if (checkedElements.length > 0) {
            return ((CXFInstall)checkedElements[0]).getVersion();
        }
        return null;
    }

    private void setCheckedVersion(String version) {
        TableItem[] tableItems;
        TableItem[] tableItemArray = tableItems = this.cxfInstallations.getTable().getItems();
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem install = tableItemArray[n2];
            if (install.getText(0).equals(version)) {
                install.setChecked(true);
            }
            ++n2;
        }
    }

    private void setCheckedInstall(Object element) {
        if (element == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.previousInstall)) {
            this.previousInstall = selection;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            CXFInstall install = (CXFInstall)structuredSelection.getFirstElement();
            if (install != null) {
                this.cxfInstallations.setCheckedElements(new Object[]{install});
                this.cxfInstallations.reveal((Object)install);
                this.context.setDefaultRuntimeVersion(install.getVersion());
                this.context.setDefaultRuntimeLocation(install.getLocation());
                this.context.setDefaultRuntimeType(install.getType());
                this.exportCXFClasspathContainerButton.setEnabled(true);
            } else {
                this.context.setDefaultRuntimeVersion("");
                this.context.setDefaultRuntimeLocation("");
                this.context.setDefaultRuntimeType("");
                this.exportCXFClasspathContainerButton.setEnabled(false);
            }
            this.handlePreferenceControls();
        }
    }

    private void handlePreferenceControls() {
        if (this.context.getDefaultRuntimeLocation().equals("") || this.context.getDefaultRuntimeVersion().equals("")) {
            this.java2WSStackLayout.topControl = this.java2WSBlankPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2JavaBlankPreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsBlankPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springConfigBlankPreferencesComposite;
        } else if (this.context.getDefaultRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSStackLayout.topControl = this.java2WSPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2Java21PreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springPreferencesComposite;
        } else {
            this.java2WSStackLayout.topControl = this.java2WSDLPreferencesComposite;
            this.wsdl2javaStackLayout.topControl = this.wsdl2Java20PreferencesComposite;
            this.jaxwsStackLayout.topControl = this.jaxwsPreferencesComposite;
            this.springConfigStackLayout.topControl = this.springPreferencesComposite;
        }
        this.java2WSPreferncesGroup.layout();
        this.wsdl2JavaPreferencesGroup.layout();
        this.jaxwsPreferencesGroup.layout();
        this.springConfigPreferncesGroup.layout();
        this.refresh();
    }

    private void setDefaults() {
        this.exportCXFClasspathContainerButton.setSelection(CXFModelUtils.getDefaultBooleanValue((int)0, (int)10));
        this.java2WSDLRuntimePreferencesComposite.setDefaults();
        this.java2WSRuntimePreferencesComposite.setDefaults();
        this.cxf20WSDL2JavaPreferencesComposite.setDefaults();
        this.cxf21WSDL2JavaPreferencesComposite.setDefaults();
        this.annotationsComposite.setDefaults();
        this.springConfigComposite.setDefaults();
    }

    private void refresh() {
        if (this.context.getDefaultRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSRuntimePreferencesComposite.refresh();
            this.cxf21WSDL2JavaPreferencesComposite.refresh();
        } else {
            this.java2WSDLRuntimePreferencesComposite.refresh();
            this.cxf20WSDL2JavaPreferencesComposite.refresh();
        }
    }

    private void storeValues() {
        this.context.setExportCXFClasspathContainer(this.exportCXFClasspathContainerButton.getSelection());
        if (this.context.getDefaultRuntimeVersion().compareTo("2.1") >= 0) {
            this.java2WSRuntimePreferencesComposite.storeValues();
            this.cxf21WSDL2JavaPreferencesComposite.storeValues();
        } else {
            this.java2WSDLRuntimePreferencesComposite.storeValues();
            this.cxf20WSDL2JavaPreferencesComposite.storeValues();
        }
        this.annotationsComposite.storeValues();
        this.springConfigComposite.storeValues();
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        return true;
    }

    public void dispose() {
        super.dispose();
        if (this.libraryImage != null) {
            this.libraryImage.dispose();
            this.libraryImage = null;
        }
    }
}

