/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.taglib;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.ValidationMessage;
import javax.servlet.jsp.tagext.VariableInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDVariable;
import org.eclipse.jst.jsp.core.internal.java.IJSPProblem;
import org.eclipse.jst.jsp.core.internal.taglib.BuildPathClassLoader;
import org.eclipse.jst.jsp.core.internal.taglib.CustomTag;
import org.eclipse.jst.jsp.core.internal.taglib.TaglibVariable;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.NotImplementedException;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.util.AbstractMemoryListener;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.osgi.service.event.Event;

public class TaglibHelper {
    private static final String ITERATION_QUALIFIER = "javax.servlet.jsp.tagext";
    private static final String ITERATION_NAME = "IterationTag";
    private static final boolean DEBUG;
    private IProject fProject = null;
    private ClassLoader fLoader = null;
    private IJavaProject fJavaProject;
    Set fNotFoundClasses = null;
    Map fClassMap = null;
    private MemoryListener fMemoryListener;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/taglibvars");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public TaglibHelper(IProject project) {
        this.setProject(project);
        this.fMemoryListener = new MemoryListener();
        this.fMemoryListener.connect();
        this.fNotFoundClasses = new HashSet();
        this.fClassMap = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIterationTag(IType type) throws JavaModelException, ClassNotFoundException {
        String name;
        String qualifier;
        if (type == null) {
            throw new ClassNotFoundException();
        }
        Map map = this.fClassMap;
        synchronized (map) {
            if (this.fClassMap.containsKey(type.getFullyQualifiedName())) {
                return (Boolean)this.fClassMap.get(type.getFullyQualifiedName());
            }
        }
        String[] interfaces = type.getSuperInterfaceTypeSignatures();
        boolean isIteration = false;
        int i = 0;
        while (i < interfaces.length) {
            String erasureSig = Signature.getTypeErasure((String)interfaces[i]);
            qualifier = Signature.getSignatureQualifier((String)erasureSig);
            name = Signature.getSignatureSimpleName((String)erasureSig);
            if (erasureSig.charAt(0) == 'Q') {
                String[][] types = type.resolveType(this.getQualifiedType(qualifier, name));
                if (types != null && types.length > 0) {
                    isIteration = this.handleInterface(type, types[0][0], types[0][1]);
                }
            } else {
                isIteration = this.handleInterface(type, qualifier, name);
            }
            if (isIteration) {
                return true;
            }
            ++i;
        }
        String signature = type.getSuperclassTypeSignature();
        if (signature != null) {
            String erasureSig = Signature.getTypeErasure((String)signature);
            qualifier = Signature.getSignatureQualifier((String)erasureSig);
            name = Signature.getSignatureSimpleName((String)erasureSig);
            if (erasureSig.charAt(0) == 'Q') {
                String[][] types = type.resolveType(this.getQualifiedType(qualifier, name));
                if (types != null && types.length > 0) {
                    isIteration = this.isIterationTag(this.fJavaProject.findType(types[0][0], types[0][1]));
                }
            } else {
                isIteration = this.isIterationTag(this.fJavaProject.findType(qualifier, name));
            }
        }
        this.fClassMap.put(type.getFullyQualifiedName(), isIteration);
        return isIteration;
    }

    private boolean handleInterface(IType type, String qualifier, String name) throws JavaModelException, ClassNotFoundException {
        boolean isIteration = false;
        isIteration = ITERATION_QUALIFIER.equals(qualifier) && ITERATION_NAME.equals(name) ? true : this.isIterationTag(this.fJavaProject.findType(qualifier, name));
        this.fClassMap.put(type.getFullyQualifiedName(), isIteration);
        return isIteration;
    }

    private String getQualifiedType(String qualifier, String name) {
        StringBuffer qual = new StringBuffer(qualifier);
        if (qual.length() > 0) {
            qual.append('.');
        }
        qual.append(name);
        return qual.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isIterationTag(TLDElementDeclaration elementDecl, IStructuredDocument document, ITextRegionCollection customTag, List problems) {
        block14: {
            String className = elementDecl.getTagclass();
            if (className == null || className.length() == 0 || this.fProject == null || this.fNotFoundClasses.contains(className)) {
                return false;
            }
            try {
                Map map = this.fClassMap;
                synchronized (map) {
                    if (this.fClassMap.containsKey(className)) {
                        return (Boolean)this.fClassMap.get(className);
                    }
                }
                return this.isIterationTag(this.fJavaProject.findType(className));
            }
            catch (ClassNotFoundException e) {
                this.fNotFoundClasses.add(className);
                Object createdProblem = this.createJSPProblem(document, customTag, -1610612731, JSPCoreMessages.TaglibHelper_3, className, true);
                if (createdProblem != null) {
                    problems.add(createdProblem);
                }
                if (DEBUG) {
                    Logger.logException(className, e);
                }
            }
            catch (JavaModelException e) {
                if (DEBUG) {
                    Logger.logException(className, e);
                }
            }
            catch (Exception e) {
                if (DEBUG) {
                    Logger.logException(className, e);
                }
            }
            catch (Error e) {
                if (!DEBUG) break block14;
                Logger.logException(className, e);
            }
        }
        return false;
    }

    public CustomTag getCustomTag(String tagToAdd, IStructuredDocument structuredDoc, ITextRegionCollection customTag, List problems) {
        TLDCMDocumentManager mgr;
        ModelQuery mq;
        ArrayList results = new ArrayList();
        boolean isIterationTag = false;
        String tagClass = null;
        String teiClass = null;
        if (problems == null) {
            problems = new ArrayList();
        }
        if ((mq = this.getModelQuery((IDocument)structuredDoc)) != null && (mgr = TaglibController.getTLDCMDocumentManager((IDocument)structuredDoc)) != null) {
            List<TaglibTracker> trackers = mgr.getCMDocumentTrackers(-1);
            Iterator<TaglibTracker> taglibs = trackers.iterator();
            CMDocument doc = null;
            CMNamedNodeMap elements = null;
            while (taglibs.hasNext()) {
                doc = taglibs.next();
                CMNode node = null;
                elements = doc.getElements();
                if (elements == null || (node = elements.getNamedItem(tagToAdd)) == null || node.getNodeType() != 5) continue;
                if (node instanceof CMNodeWrapper) {
                    node = ((CMNodeWrapper)node).getOriginNode();
                }
                TLDElementDeclaration tldElementDecl = (TLDElementDeclaration)node;
                tagClass = tldElementDecl.getTagclass();
                teiClass = tldElementDecl.getTeiclass();
                isIterationTag = this.isIterationTag(tldElementDecl, structuredDoc, customTag, problems);
                this.validateTagClass(structuredDoc, customTag, tldElementDecl, problems);
                this.addVariables(results, node, customTag);
                if (!(doc instanceof TaglibTracker)) break;
                String uri = ((TaglibTracker)doc).getURI();
                String prefix = ((TaglibTracker)doc).getPrefix();
                this.addTEIVariables(structuredDoc, customTag, results, tldElementDecl, prefix, uri, problems);
                break;
            }
        }
        return new CustomTag(tagToAdd, tagClass, teiClass, results.toArray(new TaglibVariable[results.size()]), isIterationTag);
    }

    public TaglibVariable[] getTaglibVariables(String tagToAdd, IStructuredDocument structuredDoc, ITextRegionCollection customTag, List problems) {
        ModelQuery mq;
        ArrayList results = new ArrayList();
        if (problems == null) {
            problems = new ArrayList();
        }
        if ((mq = this.getModelQuery((IDocument)structuredDoc)) != null) {
            TLDCMDocumentManager mgr = TaglibController.getTLDCMDocumentManager((IDocument)structuredDoc);
            if (mgr == null) {
                return new TaglibVariable[0];
            }
            List<TaglibTracker> trackers = mgr.getCMDocumentTrackers(-1);
            Iterator<TaglibTracker> taglibs = trackers.iterator();
            CMDocument doc = null;
            CMNamedNodeMap elements = null;
            while (taglibs.hasNext()) {
                doc = taglibs.next();
                CMNode node = null;
                elements = doc.getElements();
                if (elements == null || (node = elements.getNamedItem(tagToAdd)) == null || node.getNodeType() != 5) continue;
                if (node instanceof CMNodeWrapper) {
                    node = ((CMNodeWrapper)node).getOriginNode();
                }
                TLDElementDeclaration tldElementDecl = (TLDElementDeclaration)node;
                boolean tagClassFound = this.validateTagClass(structuredDoc, customTag, tldElementDecl, problems);
                this.addVariables(results, node, customTag);
                if (!tagClassFound || !(doc instanceof TaglibTracker)) continue;
                String uri = ((TaglibTracker)doc).getURI();
                String prefix = ((TaglibTracker)doc).getPrefix();
                this.addTEIVariables(structuredDoc, customTag, results, tldElementDecl, prefix, uri, problems);
            }
        }
        return results.toArray(new TaglibVariable[results.size()]);
    }

    private void addVariables(List results, CMNode node, ITextRegionCollection customTag) {
        List<TLDVariable> list = ((TLDElementDeclaration)node).getVariables();
        for (TLDVariable var : list) {
            if (!var.getDeclare()) continue;
            String varName = var.getNameGiven();
            if (varName == null) {
                varName = var.getAlias();
            }
            if (varName == null) {
                String attrName = var.getNameFromAttribute();
                ITextRegionList regions = customTag.getRegions();
                boolean attrNameFound = false;
                int i = 2;
                while (i < regions.size()) {
                    ITextRegion region = regions.get(i);
                    if ("XML_TAG_ATTRIBUTE_NAME".equals(region.getType())) {
                        attrNameFound = attrName.equals(customTag.getText(region));
                    }
                    if (attrNameFound && "XML_TAG_ATTRIBUTE_VALUE".equals(region.getType())) {
                        varName = StringUtils.strip((String)customTag.getText(region));
                    }
                    ++i;
                }
            }
            if (varName == null) continue;
            String varClass = "java.lang.String";
            if (var.getVariableClass() != null) {
                varClass = this.getVariableClass(var.getVariableClass());
            }
            results.add(new TaglibVariable(varClass, varName, var.getScope(), var.getDescription()));
        }
    }

    private String getVariableClass(String varClass) {
        String result = varClass;
        if (this.compilerSupportsParameterizedTypes()) {
            ClassLoader loader = this.getClassloader();
            try {
                try {
                    int length = ((Object[])Class.class.getMethod("getTypeParameters", null).invoke(Class.forName(varClass, true, loader), null)).length;
                    if (length > 0) {
                        StringBuffer buffer = new StringBuffer("<");
                        int i = 0;
                        while (i < length) {
                            if (i > 0) {
                                buffer.append(',');
                            }
                            buffer.append('?');
                            ++i;
                        }
                        buffer.append('>');
                        result = String.valueOf(result) + buffer.toString();
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        return result;
    }

    private boolean compilerSupportsParameterizedTypes() {
        String compliance = this.fJavaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        try {
            return (double)Float.parseFloat(compliance) >= 1.5;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void addTEIVariables(IStructuredDocument document, ITextRegionCollection customTag, List results, TLDElementDeclaration decl, String prefix, String uri, List problems) {
        block28: {
            if ("JSP Tag 2.0 File".equals(decl.getProperty("Tag Definition Source")) || this.fJavaProject == null) {
                return;
            }
            String teiClassname = decl.getTeiclass();
            if (teiClassname == null || teiClassname.length() == 0 || this.fJavaProject == null || this.fNotFoundClasses.contains(teiClassname)) {
                return;
            }
            ClassLoader loader = this.getClassloader();
            Class<?> teiClass = null;
            try {
                teiClass = Class.forName(teiClassname, true, loader);
                if (teiClass != null) {
                    Object teiObject = teiClass.newInstance();
                    if (TagExtraInfo.class.isInstance(teiObject)) {
                        TagExtraInfo tei = (TagExtraInfo)teiObject;
                        Hashtable tagDataTable = this.extractTagData(customTag);
                        TagInfo info = this.getTagInfo(decl, tei, prefix, uri);
                        if (info != null) {
                            ValidationMessage[] messages;
                            tei.setTagInfo(info);
                            TagData td = new TagData(tagDataTable);
                            VariableInfo[] vInfos = tei.getVariableInfo(td);
                            if (vInfos != null) {
                                int i = 0;
                                while (i < vInfos.length) {
                                    String className = vInfos[i].getClassName();
                                    if (className != null) {
                                        className = this.getVariableClass(className);
                                    }
                                    results.add(new TaglibVariable(className, vInfos[i].getVarName(), vInfos[i].getScope(), decl.getDescription()));
                                    ++i;
                                }
                            }
                            if ((messages = tei.validate(td)) != null && messages.length > 0) {
                                int i = 0;
                                while (i < messages.length) {
                                    Object createdProblem = this.createValidationMessageProblem(document, customTag, messages[i].getMessage());
                                    if (createdProblem != null) {
                                        problems.add(createdProblem);
                                    }
                                    ++i;
                                }
                            }
                        }
                    } else {
                        Object createdProblem = this.createJSPProblem(document, customTag, -1610612732, JSPCoreMessages.TaglibHelper_2, teiClassname, true);
                        if (createdProblem != null) {
                            problems.add(createdProblem);
                        }
                        if (DEBUG) {
                            Logger.log(2, String.valueOf(teiClassname) + " is not a subclass of TaxExtraInfo");
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                this.fNotFoundClasses.add(teiClassname);
                Object createdProblem = this.createJSPProblem(document, customTag, -1610612735, JSPCoreMessages.TaglibHelper_0, teiClassname, true);
                if (createdProblem != null) {
                    problems.add(createdProblem);
                }
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (InstantiationException e) {
                Object createdProblem = this.createJSPProblem(document, customTag, -1610612733, JSPCoreMessages.TaglibHelper_1, teiClassname, true);
                if (createdProblem != null) {
                    problems.add(createdProblem);
                }
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (IllegalAccessException e) {
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (Exception e) {
                Object createdProblem = this.createJSPProblem(document, customTag, -1610612732, JSPCoreMessages.TaglibHelper_2, teiClassname, true);
                if (createdProblem != null) {
                    problems.add(createdProblem);
                }
                if (DEBUG) {
                    this.logException(teiClassname, e);
                }
            }
            catch (Error e) {
                Object createdProblem = this.createJSPProblem(document, customTag, -1610612733, JSPCoreMessages.TaglibHelper_1, teiClassname, true);
                if (createdProblem != null) {
                    problems.add(createdProblem);
                }
                if (!DEBUG) break block28;
                this.logException(teiClassname, e);
            }
        }
    }

    private Object createJSPProblem(IStructuredDocument document, ITextRegionCollection customTag, final int problemID, final String messageKey, final String argument, boolean preferVars) {
        final String tagname = customTag.getText(customTag.getRegions().get(1));
        final int start = customTag.getNumberOfRegions() > 1 ? customTag.getStartOffset(customTag.getRegions().get(1)) : customTag.getStartOffset();
        final int end = customTag.getNumberOfRegions() > 1 ? customTag.getTextEndOffset(customTag.getRegions().get(1)) - 1 : customTag.getTextEndOffset() - 1;
        final int line = document.getLineOfOffset(start);
        IPath location = TaglibController.getLocation((IDocument)document);
        final char[] name = location == null ? new char[]{} : location.toString().toCharArray();
        return new IJSPProblem(){

            public void setSourceStart(int sourceStart) {
            }

            public void setSourceLineNumber(int lineNumber) {
            }

            public void setSourceEnd(int sourceEnd) {
            }

            public boolean isWarning() {
                return false;
            }

            public boolean isInfo() {
                return false;
            }

            public boolean isError() {
                return true;
            }

            public int getSourceStart() {
                return start;
            }

            public int getSourceLineNumber() {
                return line;
            }

            public int getSourceEnd() {
                return end;
            }

            public char[] getOriginatingFileName() {
                return name;
            }

            public String getMessage() {
                return MessageFormat.format((String)messageKey, (Object[])new String[]{tagname, argument});
            }

            public int getID() {
                return problemID;
            }

            public String[] getArguments() {
                return new String[0];
            }

            @Override
            public int getEID() {
                return problemID;
            }
        };
    }

    private Object createValidationMessageProblem(IStructuredDocument document, ITextRegionCollection customTag, final String validationMessage) {
        final int start = customTag.getNumberOfRegions() > 3 ? customTag.getStartOffset(customTag.getRegions().get(2)) : (customTag.getNumberOfRegions() > 1 ? customTag.getStartOffset(customTag.getRegions().get(1)) : customTag.getStartOffset());
        final int end = customTag.getNumberOfRegions() > 3 ? customTag.getTextEndOffset(customTag.getRegions().get(customTag.getNumberOfRegions() - 2)) - 1 : (customTag.getNumberOfRegions() > 1 ? customTag.getTextEndOffset(customTag.getRegions().get(1)) - 1 : customTag.getTextEndOffset());
        final int line = document.getLineOfOffset(start);
        IPath location = TaglibController.getLocation((IDocument)document);
        final char[] name = location == null ? new char[]{} : location.toString().toCharArray();
        return new IJSPProblem(){

            public void setSourceStart(int sourceStart) {
            }

            public void setSourceLineNumber(int lineNumber) {
            }

            public void setSourceEnd(int sourceEnd) {
            }

            public boolean isInfo() {
                return false;
            }

            public boolean isWarning() {
                return true;
            }

            public boolean isError() {
                return false;
            }

            public int getSourceStart() {
                return start;
            }

            public int getSourceLineNumber() {
                return line;
            }

            public int getSourceEnd() {
                return end;
            }

            public char[] getOriginatingFileName() {
                return name;
            }

            public String getMessage() {
                return validationMessage;
            }

            public int getID() {
                return this.getEID();
            }

            public String[] getArguments() {
                return new String[0];
            }

            @Override
            public int getEID() {
                return -1610612734;
            }
        };
    }

    private TagInfo getTagInfo(TLDElementDeclaration decl, TagExtraInfo tei, String prefix, String uri) {
        TagLibraryInfoImpl libInfo = new TagLibraryInfoImpl(prefix, uri, decl);
        CMNamedNodeMap attrs = decl.getAttributes();
        TagAttributeInfo[] attrInfos = new TagAttributeInfo[attrs.getLength()];
        TLDAttributeDeclaration attr = null;
        String type = "";
        int i = 0;
        while (i < attrs.getLength()) {
            attr = (TLDAttributeDeclaration)attrs.item(i);
            type = attr.getType();
            if (attr.getType() == null || attr.getType().equals("")) {
                type = "java.lang.String";
            }
            attrInfos[i] = new TagAttributeInfo(attr.getAttrName(), attr.isRequired(), type, false);
            ++i;
        }
        String tagName = decl.getNodeName();
        String tagClass = decl.getTagclass();
        String bodyContent = decl.getBodycontent();
        if (tagName != null && tagClass != null && bodyContent != null) {
            return new TagInfo(tagName, tagClass, bodyContent, decl.getInfo(), (TagLibraryInfo)libInfo, tei, attrInfos);
        }
        return null;
    }

    private void logException(String teiClassname, Throwable e) {
        String message = "teiClassname: [";
        if (teiClassname != null) {
            message = String.valueOf(message) + teiClassname;
        }
        message = String.valueOf(message) + "]";
        Logger.logException(message, e);
    }

    private Hashtable extractTagData(ITextRegionCollection customTag) {
        Hashtable<String, String> tagDataTable = new Hashtable<String, String>();
        ITextRegionList regions = customTag.getRegions();
        ITextRegion r = null;
        String attrName = "";
        String attrValue = "";
        int size = regions.size();
        int i = 2;
        while (i < size) {
            r = regions.get(i);
            if (r.getType() == "XML_TAG_ATTRIBUTE_NAME") {
                attrName = customTag.getText(r);
                if (size > ++i && (r = regions.get(i)).getType() == "XML_TAG_ATTRIBUTE_EQUALS" && size > ++i) {
                    r = regions.get(i);
                    String type = r.getType();
                    if (type == "XML_TAG_ATTRIBUTE_VALUE") {
                        attrValue = StringUtils.stripQuotes((String)customTag.getText(r));
                        tagDataTable.put(attrName, attrValue);
                    } else if (type == "JSP_TAG_ATTRIBUTE_VALUE_DQUOTE" || type == "JSP_TAG_ATTRIBUTE_VALUE_SQUOTE") {
                        StringBuffer buffer = new StringBuffer();
                        while (size > ++i && (r = regions.get(i)).getType() != type) {
                            buffer.append(customTag.getText(r));
                        }
                        tagDataTable.put(attrName, buffer.toString());
                    }
                }
            }
            ++i;
        }
        tagDataTable.put("jsp:id", String.valueOf(customTag.getText(regions.get(1))) + "_" + customTag.getStartOffset());
        return tagDataTable;
    }

    private ClassLoader getClassloader() {
        if (this.fLoader == null) {
            this.fLoader = new BuildPathClassLoader(this.getClass().getClassLoader(), this.fJavaProject);
        }
        return this.fLoader;
    }

    public ModelQuery getModelQuery(IDocument doc) {
        IStructuredModel model = null;
        ModelQuery mq = null;
        try {
            model = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
            mq = ModelQueryUtil.getModelQuery((IStructuredModel)model);
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return mq;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject p) {
        this.fProject = p;
        IJavaProject javaProject = JavaCore.create((IProject)p);
        if (javaProject.exists()) {
            this.fJavaProject = javaProject;
        }
    }

    private boolean isTagFile(TLDElementDeclaration decl) {
        String path = decl.getPath();
        return "JSP Tag 2.0 File".equals(decl.getProperty("Tag Definition Source")) || path != null && path.startsWith("/META-INF/tags");
    }

    private boolean validateTagClass(IStructuredDocument document, ITextRegionCollection customTag, TLDElementDeclaration decl, List problems) {
        Object createdProblem;
        if (this.isTagFile(decl) || this.fJavaProject == null) {
            return false;
        }
        String tagClassname = decl.getTagclass();
        IType tagClass = null;
        if (tagClassname != null && tagClassname.length() > 0 && this.fJavaProject.exists()) {
            try {
                tagClass = this.fJavaProject.findType(tagClassname);
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        }
        if (tagClass == null && (createdProblem = this.createJSPProblem(document, customTag, -1610612731, JSPCoreMessages.TaglibHelper_3, tagClassname, false)) != null) {
            problems.add(createdProblem);
        }
        return tagClass != null;
    }

    public void dispose() {
        this.fLoader = null;
        this.fJavaProject = null;
        this.fProject = null;
        this.fNotFoundClasses = null;
        this.fClassMap = null;
        this.fMemoryListener.disconnect();
        this.fMemoryListener = null;
    }

    public void invalidateClass(String className) {
        this.fClassMap.remove(className);
    }

    private class MemoryListener
    extends AbstractMemoryListener {
        MemoryListener() {
            super(new String[]{"org/eclipse/equinox/events/MemoryEvent/NORMAL", "org/eclipse/equinox/events/MemoryEvent/SERIOUS", "org/eclipse/equinox/events/MemoryEvent/CRITICAL"});
        }

        protected void handleMemoryEvent(Event event) {
            TaglibHelper.this.fNotFoundClasses.clear();
            TaglibHelper.this.fClassMap.clear();
        }
    }

    class TagLibraryInfoImpl
    extends TagLibraryInfo {
        TLDElementDeclaration decl;

        TagLibraryInfoImpl(String prefix, String uri, TLDElementDeclaration decl) {
            super(prefix, uri);
            this.decl = decl;
        }

        public String getURI() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getURI();
        }

        public String getPrefixString() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getPrefixString();
        }

        public String getShortName() {
            return ((TLDDocument)this.decl.getOwnerDocument()).getShortname();
        }

        public String getReliableURN() {
            return ((TLDDocument)this.decl.getOwnerDocument()).getUri();
        }

        public String getInfoString() {
            return ((TLDDocument)this.decl.getOwnerDocument()).getInfo();
        }

        public String getRequiredVersion() {
            return ((TLDDocument)this.decl.getOwnerDocument()).getJspversion();
        }

        public TagInfo[] getTags() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getTags();
        }

        public TagFileInfo[] getTagFiles() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getTagFiles();
        }

        public TagInfo getTag(String shortname) {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getTag(shortname);
        }

        public TagFileInfo getTagFile(String shortname) {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getTagFile(shortname);
        }

        public FunctionInfo[] getFunctions() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return super.getFunctions();
        }

        public FunctionInfo getFunction(String name) {
            new NotImplementedException(name).printStackTrace();
            return super.getFunction(name);
        }

        public TagLibraryInfo[] getTagLibraryInfos() {
            if (Platform.inDebugMode()) {
                new NotImplementedException().printStackTrace();
            }
            return new TagLibraryInfo[]{this};
        }
    }
}

