/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.internal.CompositeTagRegistryFactory;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletRegistryManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewUtil {
    private static final String HTMLSOURCE_CONTENT_TYPE_ID = "org.eclipse.wst.html.core.htmlsource";
    private static final String XMLNS = "xmlns";

    public static TLDDocument findTLDDocument(IProject project, String uri) {
        ITaglibRecord[] tldrecs;
        ITaglibRecord[] iTaglibRecordArray = tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)project.getFullPath());
        int n = tldrecs.length;
        int n2 = 0;
        while (n2 < n) {
            ITaglibRecord rec = iTaglibRecordArray[n2];
            String matchUri = rec.getDescriptor().getURI();
            if (uri.equals(matchUri)) {
                CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
                return (TLDDocument)factory.createCMDocument(rec);
            }
            ++n2;
        }
        return null;
    }

    public static Set<Attr> getDeclaredNamespaces(NamedNodeMap attributes) {
        HashSet<Attr> alreadyUsed = new HashSet<Attr>();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrValue;
            Node node = attributes.item(i);
            if ((XMLNS.equals(node.getNodeName()) || XMLNS.equals(node.getPrefix())) && (attrValue = node.getNodeValue()) != null && !"".equals(attrValue.trim()) && node instanceof Attr) {
                alreadyUsed.add((Attr)node);
            }
            ++i;
        }
        return alreadyUsed;
    }

    public static boolean hasAttributeValue(Set<Attr> attrSet, String value) {
        for (Attr attr : attrSet) {
            if (!value.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }

    public static ITagRegistry getHtmlTagRegistry(IProject project) {
        IContentType contentType = Platform.getContentTypeManager().getContentType(HTMLSOURCE_CONTENT_TYPE_ID);
        CompositeTagRegistryFactory.TagRegistryIdentifier id = new CompositeTagRegistryFactory.TagRegistryIdentifier(project, contentType);
        ITagRegistry tagRegistry = CompositeTagRegistryFactory.getInstance().getRegistry(id);
        return tagRegistry;
    }

    public static Map<String, PrefixEntry> getDocumentNamespaces(Document doc) {
        HashMap<String, PrefixEntry> namespaces = new HashMap<String, PrefixEntry>();
        Element rootElement = doc.getDocumentElement();
        if (rootElement != null) {
            NamedNodeMap attrs = rootElement.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                Attr a = (Attr)attrs.item(i);
                PrefixEntry ns = PrefixEntry.parseNamespace(a);
                if (ns != null) {
                    namespaces.put(ns._prefix, ns);
                }
                ++i;
            }
        }
        return namespaces;
    }

    public static boolean isFaceletVDLFile(IFile file) {
        IDTViewHandler viewHandler;
        DesignTimeApplicationManager instance = DesignTimeApplicationManager.getInstance((IProject)file.getProject());
        if (instance != null && (viewHandler = instance.getViewHandler()) != null) {
            return viewHandler.supportsViewDefinition(file);
        }
        return false;
    }

    public static ITagRegistry getTagRegistry(IProject project) {
        FaceletRegistryManager.MyRegistryFactory factory = new FaceletRegistryManager.MyRegistryFactory();
        ITagRegistry registry = null;
        try {
            registry = factory.createTagRegistry(project);
        }
        catch (TagRegistryFactory.TagRegistryFactoryException tagRegistryFactoryException) {}
        return registry;
    }

    public static XMLViewDefnAdapter.DTELExpression getDTELExpression(IModelContext genericContext) {
        IStructuredDocumentContext context = (IStructuredDocumentContext)genericContext.getAdapter(IStructuredDocumentContext.class);
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        if (resolver != null) {
            int elCloseIdx;
            String attributeText;
            int elOpenIdx;
            String regionType = resolver.getRegionType();
            int startOffset = resolver.getStartOffset();
            int relativeOffset = context.getDocumentPosition() - startOffset;
            if ("XML_TAG_ATTRIBUTE_VALUE".equals(regionType) && (elOpenIdx = (attributeText = resolver.getRegionText()).indexOf("#")) >= 0 && elOpenIdx < relativeOffset && elOpenIdx + 1 < attributeText.length() && attributeText.charAt(elOpenIdx + 1) == '{' && (elCloseIdx = attributeText.indexOf(125, elOpenIdx + 1)) != -1) {
                IStructuredDocumentContext elContext = IStructuredDocumentContextFactory.INSTANCE.getContext(context.getStructuredDocument(), resolver.getStartOffset() + elOpenIdx + 2);
                String elText = attributeText.substring(elOpenIdx + 2, elCloseIdx);
                return new XMLViewDefnAdapter.DTELExpression(elContext, elText);
            }
        }
        return null;
    }

    public static class PrefixEntry {
        private final String _uri;
        private final String _prefix;

        public static PrefixEntry parseNamespace(Attr attr) {
            String uri;
            String prefixName;
            String prefix = attr.getPrefix();
            if (ViewUtil.XMLNS.equals(prefix) && (prefixName = attr.getLocalName()) != null && (uri = attr.getNodeValue()) != null) {
                return new PrefixEntry(uri, prefixName);
            }
            return null;
        }

        public PrefixEntry(String uri, String prefix) {
            this._uri = uri;
            this._prefix = prefix;
        }

        public final String getUri() {
            return this._uri;
        }

        public final String getPrefix() {
            return this._prefix;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object obj) {
            return this._uri.equals(obj);
        }
    }
}

