/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;

public class IsARelation {
    protected static final String SEPARATOR = ";isA;";
    public static final String IS_A_CONNECTION_PROP_KEY = "is_is_a_connection";
    protected PersistentType subclass;
    protected PersistentType superclass;

    public IsARelation(PersistentType subclass, PersistentType superclass) {
        this.subclass = subclass;
        this.superclass = superclass;
    }

    public IsARelation(IJPAEditorFeatureProvider fp, Connection conn) {
        Anchor start = conn.getStart();
        Anchor end = conn.getEnd();
        Object startObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)start.eContainer()));
        Object endObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)end.eContainer()));
        if (startObj == null || endObj == null) {
            throw new NullPointerException("Some of the connection ends is null");
        }
        if (!(startObj instanceof PersistentType) || !(endObj instanceof PersistentType)) {
            throw new IllegalArgumentException();
        }
        this.subclass = (PersistentType)startObj;
        this.superclass = (PersistentType)endObj;
    }

    public PersistentType getSubclass() {
        return this.subclass;
    }

    public PersistentType getSuperclass() {
        return this.superclass;
    }

    public static boolean isIsAConnection(Connection conn) {
        String val = JPAEditorUtil.getPeUtil().getPropertyValue((PropertyContainer)conn, IS_A_CONNECTION_PROP_KEY);
        return Boolean.TRUE.toString().equals(val);
    }

    public String getId() {
        return IsARelation.generateId(this.subclass, this.superclass);
    }

    public static String generateId(IJPAEditorFeatureProvider fp, Connection conn) {
        Anchor start = conn.getStart();
        Anchor end = conn.getEnd();
        Object startObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)start.eContainer()));
        Object endObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)end.eContainer()));
        if (startObj == null || endObj == null) {
            return null;
        }
        if (!(startObj instanceof PersistentType) || !(endObj instanceof PersistentType)) {
            return null;
        }
        PersistentType startJpt = (PersistentType)startObj;
        PersistentType endJpt = (PersistentType)endObj;
        return IsARelation.generateId(startJpt, endJpt);
    }

    private static String generateId(PersistentType startJpt, PersistentType endJpt) {
        return "is_a_relation:" + startJpt.getName() + SEPARATOR + endJpt.getName();
    }

    public boolean equals(Object otherRel) {
        if (!IsARelation.class.isInstance(otherRel)) {
            return false;
        }
        return this.getId().equals(((IsARelation)otherRel).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

