/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.widgets;

import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class FormWidgetFactory
implements WidgetFactory {
    private final FormToolkit formToolkit;

    public FormWidgetFactory(FormToolkit formToolkit) {
        if (formToolkit == null) {
            throw new NullPointerException();
        }
        this.formToolkit = formToolkit;
    }

    @Override
    public Button createButton(Composite parent, String text) {
        return this.createButton(parent, text, 0);
    }

    @Override
    public Button createCheckBox(Composite parent, String text) {
        return this.createButton(parent, text, 32);
    }

    @Override
    public Combo createCombo(Composite parent) {
        return this.createCombo(parent, 8);
    }

    @Override
    public Composite createComposite(Composite parent) {
        return this.formToolkit.createComposite(parent);
    }

    @Override
    public DateTime createDateTime(Composite parent, int style) {
        parent = this.createBorderContainer(parent);
        DateTime dateTime = new DateTime(parent, style | 0x800000);
        dateTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.formToolkit.adapt((Control)dateTime, true, false);
        return dateTime;
    }

    @Override
    public Combo createEditableCombo(Composite parent) {
        return this.createCombo(parent, 0);
    }

    @Override
    public Group createGroup(Composite parent, String title) {
        Group group = new Group(parent, 0);
        group.setText(title);
        return group;
    }

    @Override
    public Hyperlink createHyperlink(Composite parent, String text) {
        return this.formToolkit.createHyperlink(parent, text, 0x800000);
    }

    @Override
    public Label createLabel(Composite container, String labelText) {
        return this.formToolkit.createLabel(container, labelText, 64);
    }

    @Override
    public List createList(Composite container, int style) {
        List list = new List(container, 0x800000 | style);
        list.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        return list;
    }

    @Override
    public Text createMultiLineText(Composite parent) {
        return this.createText(parent, 514);
    }

    @Override
    public Text createPasswordText(Composite parent) {
        return this.createText(parent, 0x400000);
    }

    @Override
    public Button createPushButton(Composite parent, String text) {
        return this.createButton(parent, text, 8);
    }

    @Override
    public Button createRadioButton(Composite parent, String text) {
        return this.createButton(parent, text, 16);
    }

    @Override
    public Section createSection(Composite parent, int style) {
        return this.formToolkit.createSection(parent, 0x800000 | style);
    }

    public ScrolledForm createScrolledForm(Composite parent) {
        return this.formToolkit.createScrolledForm(parent);
    }

    @Override
    public Spinner createSpinner(Composite parent) {
        parent = this.createBorderContainer(parent);
        Spinner spinner = new Spinner(parent, 0x800000);
        spinner.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.formToolkit.adapt((Control)spinner, true, false);
        return spinner;
    }

    @Override
    public Table createTable(Composite parent, int style) {
        Table table = this.formToolkit.createTable(parent, 0x800 | style);
        table.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        return table;
    }

    @Override
    public Text createText(Composite parent) {
        return this.createText(parent, 0);
    }

    private Text createText(Composite parent, int style) {
        return this.formToolkit.createText(parent, null, 0x800800 | style);
    }

    @Override
    public Button createTriStateCheckBox(Composite parent, String text) {
        TriStateCheckBox checkBox = new TriStateCheckBox(parent, text, this);
        return checkBox.getCheckBox();
    }

    private Composite createBorderContainer(Composite parent) {
        return this.createBorderContainer(parent, 2, 1);
    }

    private Composite createBorderContainer(Composite parent, int marginHeight, int marginWidth) {
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = marginHeight;
        layout.marginWidth = marginWidth;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Composite composite = this.formToolkit.createComposite(parent);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)layout);
        return composite;
    }

    private Button createButton(Composite parent, String text, int style) {
        return this.formToolkit.createButton(parent, text, 0x800000 | style);
    }

    private Combo createCombo(Composite parent, int style) {
        return new Combo(parent, style | 0x800000);
    }

    @Override
    public void dispose() {
        this.formToolkit.dispose();
    }
}

