/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.xcore.ui.editor;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProvider;
import org.eclipse.emf.codegen.ecore.genmodel.provider.GenModelItemProviderAdapterFactory;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xcore.XAnnotation;
import org.eclipse.emf.ecore.xcore.XNamedElement;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.emf.ecore.xcore.XcorePackage;
import org.eclipse.emf.ecore.xcore.mappings.ToXcoreMapping;
import org.eclipse.emf.ecore.xcore.mappings.XcoreMapper;
import org.eclipse.emf.ecore.xcore.services.XcoreGrammarAccess;
import org.eclipse.emf.ecore.xcore.ui.editor.XcoreEditor;
import org.eclipse.emf.ecore.xcore.ui.quickfix.XcoreQuickfixProvider;
import org.eclipse.emf.ecore.xcore.util.XcoreGenModelInitializer;
import org.eclipse.emf.ecore.xcore.validation.XcoreResourceValidator;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditorActionContributor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class CustomXcoreEditor
extends XcoreEditor {
    @Inject
    private XcoreMapper mapper;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    XcoreGrammarAccess xcoreGrammarAccess;
    @Inject
    XcoreGenModelInitializer genModelInitializer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected ComposedAdapterFactory adapterFactory;

    public Object getAdapter(Class type) {
        if (type.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(type);
    }

    public IPropertySheetPage getPropertySheetPage() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new GenModelItemProviderAdapterFactory(){

            public Adapter createGenModelAdapter() {
                return new GenModelItemProvider((AdapterFactory)this){

                    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
                        if (this.itemPropertyDescriptors == null) {
                            super.getPropertyDescriptors(object);
                            GenModel genModel = (GenModel)object;
                            EList genPackages = genModel.getGenPackages();
                            if (!genPackages.isEmpty()) {
                                GenPackage genPackage = (GenPackage)genPackages.get(0);
                                List genPackagePropertyDescriptors = itemDelegator.getPropertyDescriptors((Object)genPackage);
                                for (IItemPropertyDescriptor genPackagePropertyDescriptor : genPackagePropertyDescriptors) {
                                    this.itemPropertyDescriptors.add(new ItemPropertyDescriptorDecorator((Object)genPackage, genPackagePropertyDescriptor));
                                }
                            }
                        }
                        return this.itemPropertyDescriptors;
                    }
                };
            }
        });
        final IXtextDocument document = this.getDocument();
        final ResourceSet resourceSet = (ResourceSet)document.readOnly((IUnitOfWork)new IUnitOfWork<ResourceSet, XtextResource>(){

            public ResourceSet exec(XtextResource xtextResource) throws Exception {
                return xtextResource.getResourceSet();
            }
        });
        BasicCommandStack commandStack = new BasicCommandStack(){

            protected boolean isDefault(GenModel genModel, EObject eObject, EStructuralFeature eStructuralFeature) {
                ResourceImpl fakeResource = new ResourceImpl(genModel.eResource().getURI());
                final GenModel clonedGenModel = GenModelFactory.eINSTANCE.createGenModel();
                EList genPackages = genModel.getGenPackages();
                if (!genPackages.isEmpty()) {
                    clonedGenModel.initialize(Collections.singleton(((GenPackage)genPackages.get(0)).getEcorePackage()));
                }
                CustomXcoreEditor.this.genModelInitializer.initialize(clonedGenModel, false);
                fakeResource.getContents().add((Object)clonedGenModel);
                EObject clonedEObject = new Object(){

                    EObject traverse(EObject eObject) {
                        EObject eContainer = eObject.eContainer();
                        if (eContainer == null) {
                            return clonedGenModel;
                        }
                        EReference eContainmentFeature = eObject.eContainmentFeature();
                        EObject clonedEObject = this.traverse(eContainer);
                        Object value = clonedEObject.eGet((EStructuralFeature)eContainmentFeature);
                        if (eContainmentFeature.isMany()) {
                            List values = (List)value;
                            List originalValues = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                            return (EObject)values.get(originalValues.indexOf(eObject));
                        }
                        return (EObject)value;
                    }
                }.traverse(eObject);
                Object newValue = eObject.eGet(eStructuralFeature);
                Object defaultValue = clonedEObject.eGet(eStructuralFeature);
                return newValue == null ? defaultValue == null : (newValue instanceof GenFeature && defaultValue instanceof GenFeature ? ((GenFeature)newValue).getEcoreFeature() == ((GenFeature)defaultValue).getEcoreFeature() : newValue.equals(defaultValue));
            }

            protected String getValue(EObject eObject, EStructuralFeature eStructuralFeature) {
                EClassifier eType = eStructuralFeature.getEType();
                Object value = eObject.eGet(eStructuralFeature);
                String literal = eType instanceof EDataType ? this.getEDataTypeLiteral(value, (EDataType)eType, eStructuralFeature.isMany()) : ((GenFeature)value).getName();
                return CustomXcoreEditor.this.valueConverterService.toString((Object)literal, "STRING");
            }

            protected String getEDataTypeLiteral(Object value, EDataType eDataType, boolean isMany) {
                if (isMany) {
                    StringBuilder result = new StringBuilder();
                    for (Object element : (List)value) {
                        if (result.length() != 0) {
                            result.append(" ");
                        }
                        result.append(EcoreUtil.convertToString((EDataType)eDataType, element));
                    }
                    return result.toString();
                }
                return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
            }

            public void execute(Command command) {
                final Resource resource = (Resource)resourceSet.getResources().get(0);
                final GenModel genModel = (GenModel)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)GenModelPackage.Literals.GEN_MODEL);
                final ArrayList notifications = new ArrayList();
                EContentAdapter eContentAdatper = new EContentAdapter(){

                    public void notifyChanged(Notification notification) {
                        super.notifyChanged(notification);
                        int eventType = notification.getEventType();
                        if (eventType == 8) {
                            if (notification.getNotifier() instanceof GenModel) {
                                CustomXcoreEditor.this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                                            public void process(XtextResource xtextResource) throws Exception {
                                                ISelection selection = CustomXcoreEditor.this.getSourceViewer().getSelectionProvider().getSelection();
                                                Iterator<PropertySheetPage> i = (((this).this).this).CustomXcoreEditor.this.propertySheetPages.iterator();
                                                while (i.hasNext()) {
                                                    PropertySheetPage propertySheetPage = i.next();
                                                    if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                                                        i.remove();
                                                        continue;
                                                    }
                                                    propertySheetPage.selectionChanged((IWorkbenchPart)CustomXcoreEditor.this, selection);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        } else if (!notification.isTouch() && notification.getNotifier() instanceof EObject) {
                            notifications.add(0, notification);
                        }
                    }
                };
                genModel.eAdapters().add((Object)eContentAdatper);
                super.execute(command);
                if (!notifications.isEmpty()) {
                    final Notification notification = (Notification)notifications.get(0);
                    document.modify((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                        public void process(XtextResource state) throws Exception {
                            EObject eObject = (EObject)notification.getNotifier();
                            EStructuralFeature eStructuralFeature = (EStructuralFeature)notification.getFeature();
                            String name = eStructuralFeature.getName();
                            ToXcoreMapping xcoreMapping = CustomXcoreEditor.this.mapper.getToXcoreMapping(eObject);
                            XNamedElement xNamedElement = xcoreMapping.getXcoreElement();
                            if (xNamedElement == null && eObject instanceof GenModel) {
                                xNamedElement = (XPackage)resource.getContents().get(0);
                            }
                            if (xNamedElement != null) {
                                ICompositeNode elementNode = NodeModelUtils.getNode((EObject)xNamedElement);
                                ICompositeNode annotationNode = null;
                                ICompositeNode detailNode = null;
                                List valueNodes = null;
                                XAnnotation xAnnotation = xNamedElement.getAnnotation("http://www.eclipse.org/emf/2002/GenModel");
                                if (xAnnotation != null) {
                                    annotationNode = NodeModelUtils.getNode((EObject)xAnnotation);
                                    for (Map.Entry detail : xAnnotation.getDetails()) {
                                        if (!name.equals(detail.getKey())) continue;
                                        detailNode = NodeModelUtils.findActualNodeFor((EObject)((EObject)detail));
                                        valueNodes = NodeModelUtils.findNodesForFeature((EObject)((EObject)detail), (EStructuralFeature)XcorePackage.Literals.XSTRING_TO_STRING_MAP_ENTRY__VALUE);
                                        break;
                                    }
                                }
                                if (elementNode != null) {
                                    if (annotationNode == null) {
                                        int offset = elementNode.getOffset();
                                        int line = document.getLineOfOffset(offset);
                                        String lineDelimiter = document.getLineDelimiter(line);
                                        int lineOffset = document.getLineOffset(line);
                                        String indentation = document.get(lineOffset, offset - lineOffset);
                                        int length = indentation.length();
                                        StringBuilder newIndentation = new StringBuilder(length);
                                        int i = 0;
                                        while (i < length) {
                                            int codePoint = indentation.codePointAt(i);
                                            newIndentation.appendCodePoint(Character.isSpaceChar(codePoint) ? codePoint : 32);
                                            ++i;
                                        }
                                        document.replace(lineOffset, 0, newIndentation + "@GenModel(" + name + "=" + this.getValue(eObject, eStructuralFeature) + ")" + lineDelimiter);
                                    } else if (valueNodes != null) {
                                        if (detailNode != null && this.isDefault(genModel, eObject, eStructuralFeature)) {
                                            Keyword comma = (this).CustomXcoreEditor.this.xcoreGrammarAccess.getXAnnotationAccess().getCommaKeyword_2_2_0();
                                            Keyword leftParenthesis = (this).CustomXcoreEditor.this.xcoreGrammarAccess.getXAnnotationAccess().getLeftParenthesisKeyword_2_0();
                                            Keyword rightParenthesis = (this).CustomXcoreEditor.this.xcoreGrammarAccess.getXAnnotationAccess().getRightParenthesisKeyword_2_3();
                                            int leftParenthesisOffset = -1;
                                            int commaOffset = -1;
                                            int nextDetailNodeOffset = -1;
                                            int rightParenthesisOffset = -1;
                                            boolean matched = false;
                                            for (INode child : detailNode.getParent().getChildren()) {
                                                EObject grammarElement = child.getGrammarElement();
                                                if (matched) {
                                                    if (grammarElement == rightParenthesis) {
                                                        rightParenthesisOffset = child.getOffset();
                                                        break;
                                                    }
                                                    if (!(NodeModelUtils.findActualSemanticObjectFor((INode)child) instanceof Map.Entry)) continue;
                                                    nextDetailNodeOffset = child.getOffset();
                                                    break;
                                                }
                                                if (child == detailNode) {
                                                    matched = true;
                                                    continue;
                                                }
                                                if (grammarElement == leftParenthesis) {
                                                    leftParenthesisOffset = child.getOffset();
                                                    continue;
                                                }
                                                if (grammarElement != comma) continue;
                                                commaOffset = child.getOffset();
                                            }
                                            if (commaOffset != -1) {
                                                if (rightParenthesisOffset != -1) {
                                                    document.replace(commaOffset, rightParenthesisOffset - commaOffset, "");
                                                } else {
                                                    document.replace(commaOffset + 1, nextDetailNodeOffset - commaOffset - 1, " ");
                                                }
                                            } else if (rightParenthesisOffset != -1) {
                                                XcoreQuickfixProvider.RemovalRegion removalRegion = new XcoreQuickfixProvider.RemovalRegion(document, (EObject)xAnnotation);
                                                document.replace(removalRegion.getDeleteBegin(), removalRegion.getDeleteEnd() - removalRegion.getDeleteBegin(), "");
                                            } else {
                                                document.replace(leftParenthesisOffset + 1, nextDetailNodeOffset - leftParenthesisOffset - 1, "");
                                            }
                                        } else {
                                            INode valueNode = (INode)valueNodes.get(0);
                                            document.replace(valueNode.getOffset(), valueNode.getLength(), this.getValue(eObject, eStructuralFeature));
                                        }
                                    } else if (xAnnotation != null && xAnnotation.getDetails().isEmpty()) {
                                        int offset = annotationNode.getOffset() + annotationNode.getLength();
                                        document.replace(offset, 0, "(" + name + "=" + this.getValue(eObject, eStructuralFeature) + ")");
                                    } else {
                                        int offset = annotationNode.getOffset() + annotationNode.getLength() - 1;
                                        document.replace(offset, 0, ", " + name + "=" + this.getValue(eObject, eStructuralFeature));
                                    }
                                }
                            }
                        }
                    });
                }
            }
        };
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, resourceSet){

            public boolean isReadOnly(Resource resource) {
                return super.isReadOnly(resource) || this.getResourceSet().getResources().indexOf((Object)resource) != 0;
            }
        };
        class EditingDomainProvider
        extends AdapterImpl
        implements IEditingDomainProvider {
            private final /* synthetic */ AdapterFactoryEditingDomain val$editingDomain;

            EditingDomainProvider(AdapterFactoryEditingDomain adapterFactoryEditingDomain) {
                this.val$editingDomain = adapterFactoryEditingDomain;
            }

            public EditingDomain getEditingDomain() {
                return this.val$editingDomain;
            }

            public boolean isAdapterForType(Object type) {
                return IEditingDomainProvider.class.equals(type);
            }
        }
        resourceSet.eAdapters().add((Object)new EditingDomainProvider(editingDomain));
        resourceSet.eAdapters().add((Object)new XcoreResourceValidator.ValidationAdapter(){

            public void update(Diagnostic diagnostic) {
                DiagnosticDecorator.DiagnosticDecoratorAdapter.update((Notifier)resourceSet, (Diagnostic)diagnostic);
            }
        });
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(editingDomain, ExtendedPropertySheetPage.Decoration.MANUAL){
            protected DelayedProcessor<Control, ITextSelection> delayedProcessor;

            public void createControl(Composite parent) {
                super.createControl(parent);
                this.delayedProcessor = new DelayedProcessor<Control, ITextSelection>(this.getControl(), 1000){
                    protected long lastModification;
                    {
                        CustomXcoreEditor.this.getSourceViewer().getTextWidget().addModifyListener(new ModifyListener(){

                            public void modifyText(ModifyEvent modifyEvent) {
                                lastModification = System.currentTimeMillis();
                            }
                        });
                    }

                    @Override
                    protected boolean isStale(ITextSelection newValue) {
                        return newValue.getOffset() != ((CustomXcoreEditor)(this).CustomXcoreEditor.this).getSourceViewer().getTextWidget().getSelection().x;
                    }

                    @Override
                    public void delayedProcess(ITextSelection value) {
                        if (this.runnable == null && System.currentTimeMillis() - this.lastModification > 2000L) {
                            this.process(value);
                        } else {
                            super.delayedProcess(value);
                        }
                    }

                    @Override
                    protected void process(final ITextSelection textSelection) {
                        IXtextDocument document = CustomXcoreEditor.this.getDocument();
                        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                            public void process(XtextResource xtextResource) throws Exception {
                                ILeafNode node;
                                ICompositeNode rootNode;
                                IParseResult parseResult = xtextResource.getParseResult();
                                if (parseResult != null && (rootNode = parseResult.getRootNode()) != null && (node = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)textSelection.getOffset())) != null) {
                                    EObject eObject = NodeModelUtils.findActualSemanticObjectFor((INode)node);
                                    if (!this.selectionChanged((IWorkbenchPart)CustomXcoreEditor.this, eObject) && AdapterFactoryEditingDomain.isStale((Object)this.getInput())) {
                                        this.selectionChanged((IWorkbenchPart)CustomXcoreEditor.this, (ISelection)StructuredSelection.EMPTY);
                                    }
                                }
                            }
                        });
                    }
                };
            }

            public void setSelectionToViewer(List<?> selection) {
                CustomXcoreEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                TextEditorActionContributor actionBarContributor = (TextEditorActionContributor)CustomXcoreEditor.this.getEditorSite().getActionBarContributor();
                IActionBars editorActionBars = actionBarContributor.getActionBars();
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), editorActionBars.getGlobalActionHandler(ActionFactory.UNDO.getId()));
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), editorActionBars.getGlobalActionHandler(ActionFactory.REDO.getId()));
            }

            public void selectionChanged(final IWorkbenchPart part, ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof EObjectNode) {
                        final EObjectNode eObjectNode = (EObjectNode)element;
                        IXtextDocument document = CustomXcoreEditor.this.getDocument();
                        if (!((Boolean)document.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

                            public Boolean exec(XtextResource xtextResource) throws Exception {
                                EObject eObject = eObjectNode.getEObject((Resource)xtextResource);
                                return this.selectionChanged(part, eObject);
                            }
                        })).booleanValue() && AdapterFactoryEditingDomain.isStale((Object)this.getInput())) {
                            super.selectionChanged(part, (ISelection)StructuredSelection.EMPTY);
                        }
                    } else {
                        super.selectionChanged(part, selection);
                    }
                } else if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    this.delayedProcessor.delayedProcess(textSelection);
                } else {
                    super.selectionChanged(part, selection);
                }
            }

            protected boolean selectionChanged(IWorkbenchPart part, EObject eObject) {
                if (eObject instanceof XNamedElement) {
                    GenBase genBase = CustomXcoreEditor.this.mapper.getGen((XNamedElement)eObject);
                    if (genBase instanceof GenPackage) {
                        genBase = ((GenPackage)genBase).getGenModel();
                    }
                    if (genBase != null) {
                        this.selectionChanged(part, (ISelection)new StructuredSelection((Object)genBase));
                        return true;
                    }
                } else {
                    if (eObject instanceof GenBase) {
                        this.selectionChanged(part, (ISelection)new StructuredSelection((Object)eObject));
                        return true;
                    }
                    if (eObject != null) {
                        return this.selectionChanged(part, eObject.eContainer());
                    }
                }
                return false;
            }
        };
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
                return new PropertySource(object, itemPropertySource){

                    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
                        return new PropertyDescriptor(this.object, itemPropertyDescriptor){

                            public CellEditor createPropertyEditor(Composite composite) {
                                Object value;
                                if (this.object instanceof IItemPropertySource && (value = ((IItemPropertySource)this.object).getEditableValue(this.object)) instanceof EObject && ((EObject)value).eClass().getEPackage() == EcorePackage.eINSTANCE) {
                                    return null;
                                }
                                return super.createPropertyEditor(composite);
                            }
                        };
                    }
                };
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)contentProvider);
        this.getEditorSite().getShell().getDisplay().asyncExec(new Runnable((PropertySheetPage)propertySheetPage){
            private final /* synthetic */ PropertySheetPage val$propertySheetPage;
            {
                this.val$propertySheetPage = propertySheetPage;
            }

            @Override
            public void run() {
                this.val$propertySheetPage.selectionChanged((IWorkbenchPart)CustomXcoreEditor.this, CustomXcoreEditor.this.getSourceViewer().getSelectionProvider().getSelection());
            }
        });
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
    }

    public static abstract class DelayedProcessor<C extends Control, V> {
        protected Runnable runnable;
        protected int delay;
        protected C control;
        protected V value;

        public DelayedProcessor(C control, int delay) {
            this.control = control;
            this.delay = delay;
        }

        public void delayedProcess(V value) {
            if (this.isChanged(this.value, value) && !this.isStale(value)) {
                this.value = value;
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (DelayedProcessor.this.runnable == this && !DelayedProcessor.this.control.isDisposed() && !DelayedProcessor.this.isStale(DelayedProcessor.this.value)) {
                            DelayedProcessor.this.runnable = null;
                            DelayedProcessor.this.process(DelayedProcessor.this.value);
                        }
                    }
                };
                this.control.getDisplay().timerExec(this.delay, this.runnable);
            }
        }

        protected boolean isChanged(V oldValue, V newValue) {
            return oldValue == null ? newValue != null : !oldValue.equals(newValue);
        }

        protected boolean isStale(V newValue) {
            return false;
        }

        protected abstract void process(V var1);
    }
}

