/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.internal.server.Repository;
import org.eclipse.emf.cdo.internal.server.ServerCDOView;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.syncing.FailoverParticipant;
import org.eclipse.emf.cdo.internal.server.syncing.OfflineClone;
import org.eclipse.emf.cdo.internal.server.syncing.RepositorySynchronizer;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRepositorySynchronizer;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.ISessionManager;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ISynchronizableRepository;
import org.eclipse.emf.cdo.server.IView;
import org.eclipse.emf.cdo.session.CDOSessionConfigurationFactory;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.ManagedRevisionProvider;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalRepositorySynchronizer;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CDOServerUtil {
    private CDOServerUtil() {
    }

    public static CDOView openView(ISession session, CDOBranchPoint branchPoint, CDORevisionProvider revisionProvider) {
        return new ServerCDOView((InternalSession)session, branchPoint, revisionProvider);
    }

    public static CDOView openView(ISession session, CDOBranchPoint branchPoint) {
        CDORevisionManager revisionManager = session.getManager().getRepository().getRevisionManager();
        ManagedRevisionProvider revisionProvider = new ManagedRevisionProvider(revisionManager, branchPoint);
        return CDOServerUtil.openView(session, branchPoint, (CDORevisionProvider)revisionProvider);
    }

    public static CDOView openView(IView view) {
        ISession session = view.getSession();
        CDOBranchPoint branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)view);
        return CDOServerUtil.openView(session, branchPoint, (CDORevisionProvider)view);
    }

    public static CDOView openView(IStoreAccessor.CommitContext commitContext) {
        ISession session = commitContext.getTransaction().getSession();
        CDOBranchPoint branchPoint = commitContext.getBranchPoint();
        return CDOServerUtil.openView(session, branchPoint, commitContext);
    }

    @Deprecated
    public static CDOView openView(ISession session, CDOBranchPoint branchPoint, boolean legacyModeEnabled, CDORevisionProvider revisionProvider) {
        return CDOServerUtil.openView(session, branchPoint, revisionProvider);
    }

    @Deprecated
    public static CDOView openView(ISession session, CDOBranchPoint branchPoint, boolean legacyModeEnabled) {
        return CDOServerUtil.openView(session, branchPoint);
    }

    @Deprecated
    public static CDOView openView(IView view, boolean legacyModeEnabled) {
        return CDOServerUtil.openView(view);
    }

    @Deprecated
    public static CDOView openView(IStoreAccessor.CommitContext commitContext, boolean legacyModeEnabled) {
        return CDOServerUtil.openView(commitContext);
    }

    public static ISession getServerSession(CDOView view) {
        if (view instanceof ServerCDOView) {
            return ((ServerCDOView)view).getServerSession();
        }
        return null;
    }

    public static ISessionManager createSessionManager() {
        return new SessionManager();
    }

    public static IRepository createRepository(String name, IStore store, Map<String, String> props) {
        Repository.Default repository = new Repository.Default();
        CDOServerUtil.initRepository(repository, name, store, props);
        return repository;
    }

    public static IRepositorySynchronizer createRepositorySynchronizer(CDOSessionConfigurationFactory remoteSessionConfigurationFactory) {
        RepositorySynchronizer synchronizer = new RepositorySynchronizer();
        synchronizer.setRemoteSessionConfigurationFactory(remoteSessionConfigurationFactory);
        return synchronizer;
    }

    public static ISynchronizableRepository createOfflineClone(String name, IStore store, Map<String, String> props, IRepositorySynchronizer synchronizer) {
        OfflineClone repository = new OfflineClone();
        CDOServerUtil.initRepository(repository, name, store, props);
        repository.setSynchronizer((InternalRepositorySynchronizer)synchronizer);
        return repository;
    }

    public static ISynchronizableRepository createFailoverParticipant(String name, IStore store, Map<String, String> props, IRepositorySynchronizer synchronizer, boolean master, boolean allowBackupCommits) {
        FailoverParticipant repository = new FailoverParticipant();
        CDOServerUtil.initRepository(repository, name, store, props);
        if (synchronizer != null) {
            repository.setSynchronizer((InternalRepositorySynchronizer)synchronizer);
            repository.setType(master ? CDOCommonRepository.Type.MASTER : CDOCommonRepository.Type.BACKUP);
        }
        return repository;
    }

    public static ISynchronizableRepository createFailoverParticipant(String name, IStore store, Map<String, String> props, IRepositorySynchronizer synchronizer, boolean master) {
        return CDOServerUtil.createFailoverParticipant(name, store, props, synchronizer, master, false);
    }

    public static ISynchronizableRepository createFailoverParticipant(String name, IStore store, Map<String, String> props, IRepositorySynchronizer synchronizer) {
        return CDOServerUtil.createFailoverParticipant(name, store, props, synchronizer, false);
    }

    public static ISynchronizableRepository createFailoverParticipant(String name, IStore store, Map<String, String> props) {
        return CDOServerUtil.createFailoverParticipant(name, store, props, null);
    }

    private static void initRepository(Repository repository, String name, IStore store, Map<String, String> props) {
        repository.setName(name);
        repository.setStore((InternalStore)store);
        repository.setProperties(props);
    }

    public static void addRepository(IManagedContainer container, IRepository repository) {
        InternalRepository internal = (InternalRepository)repository;
        if (internal.getContainer() == null && container != IPluginContainer.INSTANCE) {
            internal.setContainer(container);
        }
        String productGroup = "org.eclipse.emf.cdo.server.repositories";
        String type = "default";
        String name = repository.getName();
        container.putElement(productGroup, type, name, (Object)repository);
        LifecycleUtil.activate((Object)repository);
    }

    public static IRepository getRepository(IManagedContainer container, String name) {
        return RepositoryFactory.get(container, name);
    }

    public static Element getRepositoryConfig(String repositoryName) throws ParserConfigurationException, SAXException, IOException {
        File configFile = OMPlatform.INSTANCE.getConfigFile("cdo-server.xml");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(configFile);
        NodeList elements = document.getElementsByTagName("repository");
        int i = 0;
        while (i < elements.getLength()) {
            Element element;
            String name;
            Node node = elements.item(i);
            if (node instanceof Element && ObjectUtil.equals((Object)(name = (element = (Element)node).getAttribute("name")), (Object)repositoryName)) {
                return element;
            }
            ++i;
        }
        throw new IllegalStateException("Repository config not found: " + repositoryName);
    }

    public static abstract class RepositoryReadAccessValidator
    implements IRepository.ReadAccessHandler {
        @Override
        public void handleRevisionsBeforeSending(ISession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) throws RuntimeException {
            ArrayList<String> violations = new ArrayList<String>();
            CDORevision[] cDORevisionArray = revisions;
            int n = revisions.length;
            int n2 = 0;
            while (n2 < n) {
                CDORevision revision = cDORevisionArray[n2];
                String violation = this.validate(session, revision);
                if (violation != null) {
                    violations.add(violation);
                }
                ++n2;
            }
            if (!violations.isEmpty()) {
                this.throwException(session, violations);
            }
            Iterator<CDORevision> it = additionalRevisions.iterator();
            while (it.hasNext()) {
                CDORevision revision = it.next();
                String violation = this.validate(session, revision);
                if (violation == null) continue;
                OM.LOG.info("Revision can not be delivered to " + session + ": " + violation);
                it.remove();
            }
        }

        protected void throwException(ISession session, List<String> violations) throws RuntimeException {
            StringBuilder builder = new StringBuilder();
            builder.append("Revisions can not be delivered to ");
            builder.append(session);
            builder.append(":");
            for (String violation : violations) {
                builder.append("\n- ");
                builder.append(violation);
            }
            this.throwException(builder.toString());
        }

        protected void throwException(String message) throws RuntimeException {
            throw new IllegalStateException(message);
        }

        protected abstract String validate(ISession var1, CDORevision var2);
    }
}

