/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.internal.signing.GpgConfigurationException;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.egit.ui.internal.jobs.GpgConfigProblemReportAction;
import org.eclipse.egit.ui.internal.push.PushTagsWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TagActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevCommit tagTarget;
        CreateTagDialog dialog;
        Repository repo;
        IRepositoryCommit commit = this.getCommit(TagActionHandler.getSelection(event));
        if (commit == null) {
            String currentBranchName;
            repo = this.getRepository(true, event);
            if (repo == null) {
                return null;
            }
            if (!repo.getRepositoryState().canCheckout()) {
                MessageDialog.openError((Shell)this.getShell(event), (String)UIText.TagAction_cannotCheckout, (String)MessageFormat.format(UIText.TagAction_repositoryState, repo.getRepositoryState().getDescription()));
                return null;
            }
            try {
                currentBranchName = repo.getBranch();
            }
            catch (IOException e) {
                Activator.handleError(UIText.TagAction_cannotGetBranchName, e, true);
                return null;
            }
            dialog = new CreateTagDialog(this.getShell(event), currentBranchName, repo);
        } else {
            repo = commit.getRepository();
            if (repo == null) {
                return null;
            }
            dialog = new CreateTagDialog(this.getShell(event), commit.getRevCommit().getId(), repo);
        }
        if (dialog.open() != 0) {
            return null;
        }
        if (commit == null) {
            try {
                tagTarget = this.getTagTarget(repo, dialog.getTagCommit());
            }
            catch (IOException e) {
                Activator.handleError(UIText.TagAction_cannotGetCommit, e, true);
                return null;
            }
        } else {
            tagTarget = commit.getRevCommit();
        }
        final String tagName = dialog.getTagName();
        assert (tagName != null);
        assert (tagTarget != null);
        final TagOperation operation = new TagOperation(repo).setName(tagName).setTarget(tagTarget).setAnnotated(dialog.isAnnotated()).setForce(dialog.shouldOverWriteTag()).setSign(dialog.shouldSign()).setMessage(dialog.getTagMessage()).setCredentialsProvider((CredentialsProvider)new EGitCredentialsProvider());
        String tagJobName = MessageFormat.format(UIText.TagAction_creating, tagName);
        Job job = new Job(tagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    operation.execute(monitor);
                }
                catch (CoreException e) {
                    if (e.getCause() instanceof GpgConfigurationException) {
                        TagActionHandler.this.showGpgProblem(e.getStatus());
                        return Status.CANCEL_STATUS;
                    }
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.TAG.equals(family) || super.belongsTo(family);
            }
        };
        job.setRule(operation.getSchedulingRule());
        job.setUser(true);
        if (dialog.shouldStartPushWizard()) {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobEvent) {
                    if (jobEvent.getResult().isOK()) {
                        PushTagsWizard.openWizardDialog(repo, tagName);
                    }
                }
            });
        }
        job.schedule();
        return null;
    }

    private void showGpgProblem(IStatus status) {
        GpgConfigProblemReportAction action = new GpgConfigProblemReportAction(status, UIText.TagAction_gpgConfigProblem);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> ((IAction)action).run());
    }

    private RevCommit getTagTarget(Repository repo, ObjectId objectId) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(repo);){
            if (objectId == null) {
                return rw.parseCommit((AnyObjectId)repo.resolve("HEAD"));
            }
            return rw.parseCommit((AnyObjectId)objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IRepositoryCommit getCommit(IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            Object obj = selection.getFirstElement();
            return (IRepositoryCommit)Adapters.adapt((Object)obj, IRepositoryCommit.class);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

