/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.model;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.provisional.model.IMemoryBlockUpdatePolicyProvider;
import org.eclipse.cdt.dsf.debug.model.DsfMemoryBlockRetrieval;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.MemoryByte;

public class DsfMemoryBlock
extends PlatformObject
implements IMemoryBlockExtension,
IMemoryBlockUpdatePolicyProvider {
    private static final String UPDATE_POLICY_AUTOMATIC = "Automatic";
    private static final String UPDATE_POLICY_MANUAL = "Manual";
    private static final String UPDATE_POLICY_BREAKPOINT = "On Breakpoint";
    private final IMemory.IMemoryDMContext fContext;
    private final ILaunch fLaunch;
    private final IDebugTarget fDebugTarget;
    private final DsfMemoryBlockRetrieval fRetrieval;
    private final String fModelId;
    private final String fExpression;
    private final BigInteger fBaseAddress;
    private BigInteger fBlockAddress;
    private int fLength;
    private int fWordSize;
    private MemoryByte[] fBlock;
    private String fUpdatePolicy = "Automatic";
    private ArrayList<Object> fConnections = new ArrayList();
    private boolean isEnabled;
    private boolean fUseCachedData = false;

    protected DsfMemoryBlock(DsfMemoryBlockRetrieval retrieval, IMemory.IMemoryDMContext context, String modelId, String expression, BigInteger address, int word_size, long length) {
        this.fLaunch = retrieval.getLaunch();
        this.fDebugTarget = retrieval.getDebugTarget();
        this.fRetrieval = retrieval;
        this.fContext = context;
        this.fModelId = modelId;
        this.fExpression = expression;
        this.fBaseAddress = address;
        this.fBlockAddress = address;
        this.fWordSize = word_size;
        this.fLength = (int)length;
        this.fBlock = null;
        try {
            this.fRetrieval.getExecutor().execute(() -> this.fRetrieval.getSession().addServiceEventListener(this, null));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(DsfMemoryBlockRetrieval.class)) {
            return this.fRetrieval;
        }
        if (adapter.isAssignableFrom(IMemory.IMemoryDMContext.class)) {
            return this.getContext();
        }
        return super.getAdapter(adapter);
    }

    public IDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }

    public String getModelIdentifier() {
        return this.fModelId;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public long getStartAddress() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public byte[] getBytes() throws DebugException {
        return new byte[0];
    }

    public boolean supportsValueModification() {
        return this.fRetrieval.supportsValueModification();
    }

    public void setValue(long offset, byte[] bytes) throws DebugException {
    }

    public String getExpression() {
        return this.fExpression;
    }

    public BigInteger getBigBaseAddress() throws DebugException {
        return this.fBaseAddress;
    }

    public BigInteger getMemoryBlockStartAddress() throws DebugException {
        return null;
    }

    public BigInteger getMemoryBlockEndAddress() throws DebugException {
        return null;
    }

    public BigInteger getBigLength() throws DebugException {
        return BigInteger.valueOf(-1L);
    }

    public int getAddressSize() throws DebugException {
        return this.fRetrieval.getAddressSize();
    }

    public boolean supportBaseAddressModification() throws DebugException {
        return this.fRetrieval.supportBaseAddressModification();
    }

    public boolean supportsChangeManagement() {
        return true;
    }

    public void setBaseAddress(BigInteger address) throws DebugException {
        this.fBlockAddress = address;
    }

    public MemoryByte[] getBytesFromOffset(BigInteger offset, long units) throws DebugException {
        return this.getBytesFromAddress(this.fBlockAddress.add(offset), units);
    }

    @Override
    public void clearCache() {
        this.fUseCachedData = false;
    }

    @DsfServiceEventHandler
    public void handleCacheSuspendEvent(IRunControl.ISuspendedDMEvent e) {
        if (e.getReason() == IRunControl.StateChangeReason.BREAKPOINT) {
            this.fUseCachedData = false;
        }
    }

    private boolean isUseCacheData() {
        if (this.fUpdatePolicy.equals(UPDATE_POLICY_BREAKPOINT)) {
            return this.fUseCachedData;
        }
        if (this.fUpdatePolicy.equals(UPDATE_POLICY_MANUAL)) {
            return this.fUseCachedData;
        }
        return false;
    }

    public MemoryByte[] getBytesFromAddress(BigInteger address, long units) throws DebugException {
        int newLength;
        int addressableSize = 1;
        try {
            addressableSize = this.getAddressableSize();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (this.isUseCacheData() && this.fBlockAddress.compareTo(address) == 0 && units * (long)addressableSize <= (long)this.fBlock.length) {
            return this.fBlock;
        }
        MemoryByte[] newBlock = this.fetchMemoryBlock(address, units);
        int n = newLength = newBlock != null ? newBlock.length : 0;
        if (this.fBlock != null && newLength > 0) {
            switch (this.fBlockAddress.compareTo(address)) {
                case -1: {
                    BigInteger bigDistance = address.subtract(this.fBlockAddress).multiply(BigInteger.valueOf(addressableSize));
                    if (bigDistance.compareTo(BigInteger.valueOf(this.fLength)) != -1) break;
                    int distance = bigDistance.intValue();
                    int length = this.fLength - distance;
                    if (length > newLength) {
                        length = newLength;
                    }
                    int i = 0;
                    while (i < length) {
                        if (i < newLength) {
                            newBlock[i].setFlags(this.fBlock[distance + i].getFlags());
                            newBlock[i].setHistoryKnown(true);
                            if (newBlock[i].getValue() != this.fBlock[distance + i].getValue()) {
                                newBlock[i].setChanged(true);
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 0: 
                case 1: {
                    BigInteger bigDistance = this.fBlockAddress.subtract(address).multiply(BigInteger.valueOf(addressableSize));
                    if (bigDistance.compareTo(BigInteger.valueOf(newLength)) != -1) break;
                    int distance = bigDistance.intValue();
                    int length = newLength - distance;
                    if (length > this.fBlock.length) {
                        length = this.fBlock.length;
                    }
                    int i = 0;
                    while (i < length) {
                        if (distance + i < newLength) {
                            newBlock[distance + i].setFlags(this.fBlock[i].getFlags());
                            newBlock[distance + i].setHistoryKnown(true);
                            if (newBlock[distance + i].getValue() != this.fBlock[i].getValue()) {
                                newBlock[distance + i].setChanged(true);
                            }
                        }
                        ++i;
                    }
                    break;
                }
            }
        }
        this.fBlock = newBlock;
        this.fBlockAddress = address;
        this.fLength = newLength;
        if (this.fUpdatePolicy.equals(UPDATE_POLICY_BREAKPOINT)) {
            this.fUseCachedData = true;
        } else if (this.fUpdatePolicy.equals(UPDATE_POLICY_MANUAL)) {
            this.fUseCachedData = true;
        }
        return this.fBlock;
    }

    public void setValue(BigInteger offset, byte[] bytes) throws DebugException {
        this.writeMemoryBlock(offset.longValue(), bytes);
    }

    public void connect(Object client) {
        if (!this.fConnections.contains(client)) {
            this.fConnections.add(client);
        }
        if (this.fConnections.size() == 1) {
            this.enable();
        }
    }

    public void disconnect(Object client) {
        if (this.fConnections.contains(client)) {
            this.fConnections.remove(client);
        }
        if (this.fConnections.size() == 0) {
            this.disable();
        }
    }

    public Object[] getConnections() {
        return this.fConnections.toArray();
    }

    private void enable() {
        this.isEnabled = true;
    }

    private void disable() {
        this.isEnabled = false;
    }

    public void dispose() throws DebugException {
        try {
            this.fRetrieval.getExecutor().execute(() -> this.fRetrieval.getSession().removeServiceEventListener(this));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public IMemoryBlockRetrieval getMemoryBlockRetrieval() {
        return this.fRetrieval;
    }

    public int getAddressableSize() throws DebugException {
        return this.fWordSize;
    }

    protected MemoryByte[] fetchMemoryBlock(BigInteger bigAddress, final long count) throws DebugException {
        int aSize;
        try {
            aSize = this.getAddressableSize();
        }
        catch (DebugException e) {
            aSize = 1;
        }
        final int addressableSize = aSize;
        final Addr64 address = new Addr64(bigAddress);
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            @Override
            protected void execute(final DataRequestMonitor<MemoryByte[]> drm) {
                IMemory memoryService = (IMemory)DsfMemoryBlock.this.fRetrieval.getServiceTracker().getService();
                if (memoryService != null) {
                    memoryService.getMemory(DsfMemoryBlock.this.fContext, (IAddress)address, 0L, addressableSize, (int)count, new DataRequestMonitor<MemoryByte[]>((Executor)DsfMemoryBlock.this.fRetrieval.getExecutor(), drm){

                        @Override
                        protected void handleSuccess() {
                            drm.setData((MemoryByte[])this.getData());
                            drm.done();
                        }
                    });
                } else {
                    drm.done();
                }
            }
        };
        this.fRetrieval.getExecutor().execute(query);
        try {
            return (MemoryByte[])query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error reading memory block (InterruptedException)", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error reading memory block (ExecutionException)", (Throwable)e));
        }
    }

    protected void writeMemoryBlock(final long offset, final byte[] bytes) throws DebugException {
        int aSize;
        try {
            aSize = this.getAddressableSize();
        }
        catch (DebugException e) {
            aSize = 1;
        }
        final int addressableSize = aSize;
        final int addressableUnits = bytes.length / addressableSize;
        final Addr64 address = new Addr64(this.fBaseAddress);
        Query<MemoryByte[]> query = new Query<MemoryByte[]>(){

            @Override
            protected void execute(DataRequestMonitor<MemoryByte[]> drm) {
                IMemory memoryService = (IMemory)DsfMemoryBlock.this.fRetrieval.getServiceTracker().getService();
                if (memoryService != null) {
                    memoryService.setMemory(DsfMemoryBlock.this.fContext, (IAddress)address, offset, addressableSize, addressableUnits, bytes, new RequestMonitor(DsfMemoryBlock.this.fRetrieval.getExecutor(), drm));
                } else {
                    drm.done();
                }
            }
        };
        this.fRetrieval.getExecutor().execute(query);
        try {
            query.get();
        }
        catch (InterruptedException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error writing memory block (InterruptedException)", (Throwable)e));
        }
        catch (ExecutionException e) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.cdt.dsf", 5013, "Error writing memory block (ExecutionException)", (Throwable)e));
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        int i = 0;
        while (i < this.fLength) {
            this.fBlock[i].setChanged(false);
            ++i;
        }
        this.handleMemoryChange(BigInteger.ZERO);
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMemory.IMemoryChangedEvent e) {
        if (((IMemory.IMemoryDMContext)e.getDMContext()).equals(this.fContext)) {
            IAddress[] addresses = e.getAddresses();
            int i = 0;
            while (i < addresses.length) {
                this.handleMemoryChange(addresses[i].getValue());
                ++i;
            }
        }
    }

    public void handleMemoryChange(BigInteger address) {
        int addressableSize;
        try {
            addressableSize = this.getAddressableSize();
        }
        catch (DebugException e) {
            addressableSize = 1;
        }
        int addressesLength = this.fLength / addressableSize;
        BigInteger fEndAddress = this.fBlockAddress.add(BigInteger.valueOf(addressesLength));
        if (address.equals(BigInteger.ZERO) || this.fBlockAddress.compareTo(address) != 1 && fEndAddress.compareTo(address) == 1) {
            DebugEvent debugEvent = new DebugEvent((Object)this, 16, 512);
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
        }
    }

    @Override
    public String[] getUpdatePolicies() {
        return new String[]{UPDATE_POLICY_AUTOMATIC, UPDATE_POLICY_MANUAL, UPDATE_POLICY_BREAKPOINT};
    }

    @Override
    public String getUpdatePolicy() {
        return this.fUpdatePolicy;
    }

    @Override
    public void setUpdatePolicy(String policy) {
        this.fUpdatePolicy = policy;
    }

    @Override
    public String getUpdatePolicyDescription(String id) {
        return id;
    }

    public IMemory.IMemoryDMContext getContext() {
        return this.fContext;
    }
}

