/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts.borders;

import org.eclipse.bpel.ui.editparts.borders.RoundRectangleBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class RoundRectangleBorderWithDecoration
extends RoundRectangleBorder {
    Image decoration;
    private int decoXOffset;
    private int decoYOffset;
    private IFigure decorationFigure;

    public RoundRectangleBorderWithDecoration(IFigure parent, Image decoration) {
        this(parent, decoration, new Insets(5, 5, 5, 5));
    }

    public RoundRectangleBorderWithDecoration(IFigure parent, Image decoration, Insets insets) {
        super(insets);
        this.decoration = decoration;
        this.decoXOffset = 0;
        this.decoYOffset = -(decoration.getBounds().height / 2);
        this.decorationFigure = new ImageFigure(decoration);
        this.decorationFigure.setParent(parent);
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        super.paint(figure, graphics, insets);
        if (this.decoration != null) {
            Rectangle r = figure.getBounds();
            graphics.pushState();
            Rectangle decoBounds = new Rectangle(r.x + this.decoXOffset, r.y + this.decoYOffset, this.decoration.getBounds().width, this.decoration.getBounds().height);
            this.decorationFigure.setBounds(decoBounds);
            graphics.setClip(decoBounds);
            this.decorationFigure.paint(graphics);
            graphics.popState();
        }
    }

    public int getDecoXOffset() {
        return this.decoXOffset;
    }

    public int getDecoYOffset() {
        return this.decoYOffset;
    }

    public Image getDecoration() {
        return this.decoration;
    }

    public IFigure getDecorationFigure() {
        return this.decorationFigure;
    }
}

