/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.NumberDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public final class BubbleEntry
extends NumberDataPointEntry {
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.engine.extension/render");
    private Object oValue;
    private double dSize;
    private BigNumber bnSize;
    private Number bdSize;
    private boolean bIsBigNumber = false;
    private boolean bIsBigDecimal = false;
    private com.ibm.icu.math.BigDecimal divisor;
    private int index = 0;

    public BubbleEntry(Object value, Object size, int index) {
        this(value, size);
        this.index = index;
    }

    public BubbleEntry(Object value, Object size) {
        this.init(value, size);
    }

    private void init(Object value, Object size) {
        if (NumberUtil.isBigNumber((Object)value)) {
            this.bIsBigNumber = true;
            this.divisor = ((BigNumber)value).getDivisor();
            this.bnSize = (BigNumber)size;
        } else if (NumberUtil.isBigDecimal((Object)value)) {
            this.bIsBigDecimal = true;
            this.bdSize = NumberUtil.isJavaMathBigDecimal((Object)value) ? NumberUtil.asJavaMathBigDecimal((Number)((Number)size)) : NumberUtil.asBigDecimal((Number)((Number)size));
        }
        this.oValue = value;
        if (value instanceof Double && ((Double)value).isNaN()) {
            this.oValue = null;
        }
        this.dSize = size instanceof Number ? ((Number)size).doubleValue() : 0.0;
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public final Object getValue() {
        if (this.index > 0) {
            return this.index;
        }
        return this.oValue;
    }

    public final void setValue(Object value) {
        this.oValue = value;
        if (NumberUtil.isBigNumber((Object)value)) {
            this.bIsBigNumber = true;
            this.divisor = ((BigNumber)value).getDivisor();
        } else {
            this.bIsBigNumber = false;
        }
    }

    public final double getSize() {
        return this.bIsBigNumber ? this.bnSize.doubleValue() : this.dSize;
    }

    public final Number getSizeNumber() {
        if (this.bIsBigNumber) {
            return this.bnSize;
        }
        if (this.bIsBigDecimal) {
            return this.bdSize;
        }
        return this.dSize;
    }

    public final void setSize(double dSize) {
        this.dSize = dSize;
    }

    public final void setSize(Number size) {
        if (NumberUtil.isBigNumber((Object)size)) {
            this.dSize = ((BigNumber)size).doubleValue();
            this.bnSize = (BigNumber)size;
            return;
        }
        this.setSize(size.doubleValue());
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = null;
        try {
            if ("bubble_value".equals(type)) {
                str = ValueFormatter.format((Object)this.oValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("bubble_size".equals(type)) {
                Object size = null;
                size = this.bIsBigNumber ? this.bnSize : new Double(this.dSize);
                str = ValueFormatter.format((Object)size, (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strSize;
        String string = strSize = this.bIsBigNumber ? String.valueOf(this.bnSize) : String.valueOf(this.dSize);
        if (formatter instanceof NumberFormatSpecifier || formatter instanceof JavaNumberFormatSpecifier || formatter instanceof FractionNumberFormatSpecifier) {
            try {
                strSize = ValueFormatter.format((Object)(this.bIsBigNumber ? this.bnSize : Double.valueOf(this.dSize)), (FormatSpecifier)formatter, (ULocale)locale, null);
            }
            catch (ChartException e) {
                logger.log((Exception)((Object)e));
            }
        }
        String strValue = "";
        try {
            if (this.oValue == null) {
                return "S" + strSize;
            }
            strValue = ValueFormatter.format((Object)this.oValue, (FormatSpecifier)formatter, (ULocale)locale, null);
        }
        catch (ChartException e) {
            logger.log((Exception)((Object)e));
        }
        return "Y" + strValue + " S" + strSize;
    }

    public boolean isValid() {
        if (!this.bIsBigNumber) {
            return this.getValue() != null && !Double.isNaN(this.dSize) && this.dSize != 0.0;
        }
        return this.bnSize != null && this.bnSize.doubleValue() != 0.0;
    }

    public boolean isBigNumber() {
        return this.bIsBigNumber;
    }

    public com.ibm.icu.math.BigDecimal getDivisor() {
        return this.divisor;
    }

    public void setNumberData(Number[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        this.init(data[0], data[1]);
    }

    public Number[] getNumberData() {
        if (this.bIsBigNumber) {
            return new BigNumber[]{(BigNumber)this.oValue, this.bnSize};
        }
        if (this.bIsBigDecimal) {
            if (this.oValue instanceof com.ibm.icu.math.BigDecimal) {
                return new com.ibm.icu.math.BigDecimal[]{(com.ibm.icu.math.BigDecimal)this.oValue, (com.ibm.icu.math.BigDecimal)this.bdSize};
            }
            return new BigDecimal[]{(BigDecimal)this.oValue, (BigDecimal)this.bdSize};
        }
        if (this.oValue instanceof Number) {
            return new Double[]{((Number)this.oValue).doubleValue(), this.dSize};
        }
        return null;
    }
}

