/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.AntImageDescriptor;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.model.AntModelMessages;
import org.eclipse.ant.internal.ui.model.AntModelProblem;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.IProblem;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;

public class AntElementNode
implements IAdaptable,
IAntElement {
    protected int fOffset = -1;
    protected int fLength = -1;
    protected int fSelectionLength;
    protected AntElementNode fParent;
    private AntElementNode fImportNode;
    protected List<IAntElement> fChildNodes = null;
    protected String fName;
    private int fProblemSeverity = -1;
    private String fProblemMessage = null;
    private String fFilePath;
    private boolean fIsExternal = false;
    private String fElementPath;
    private String fElementIdentifier;
    private IProblem fProblem;
    private int fIndex = 0;
    private int fLine;
    private int fColumn;

    public AntElementNode(String aName) {
        this.fName = aName;
    }

    public AntElementNode() {
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public List<IAntElement> getChildNodes() {
        return this.fChildNodes;
    }

    @Override
    public IAntElement getParentNode() {
        return this.fParent;
    }

    @Override
    public AntProjectNode getProjectNode() {
        IAntElement projectParent = this.getParentNode();
        while (projectParent != null && !(projectParent instanceof AntProjectNode)) {
            projectParent = projectParent.getParentNode();
        }
        return (AntProjectNode)projectParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNode(AntElementNode childElement) {
        childElement.setParent(this);
        AntElementNode antElementNode = this;
        synchronized (antElementNode) {
            if (this.fChildNodes == null) {
                this.fChildNodes = new ArrayList<IAntElement>();
            }
            this.fChildNodes.add(childElement);
            childElement.setIndex(this.fChildNodes.size() - 1);
        }
    }

    private void setIndex(int index) {
        this.fIndex = index;
    }

    protected void setParent(AntElementNode node) {
        this.fParent = node;
    }

    public void setFilePath(String path) {
        if (path == null) {
            return;
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            this.fFilePath = path;
            return;
        }
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            if ("file".equals(fileURL.getProtocol())) {
                this.fFilePath = new Path(URIUtil.toFile((URI)URIUtil.toURI((URL)fileURL)).getAbsolutePath()).toString();
            }
        }
        catch (URISyntaxException e) {
            AntUIPlugin.log(e);
        }
        catch (IOException e) {
            AntUIPlugin.log(e);
        }
    }

    public String getFilePath() {
        return this.fFilePath;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public void setOffset(int anOffset) {
        this.fOffset = anOffset;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public void setLength(int aLength) {
        this.fLength = aLength;
        if (this.fProblem != null && this.fProblem instanceof AntModelProblem) {
            ((AntModelProblem)this.fProblem).setLength(aLength);
        }
    }

    public String toString() {
        return "Ant Element Node: " + this.getLabel() + " Offset: " + this.getOffset() + " Length: " + this.getLength();
    }

    @Override
    public boolean isErrorNode() {
        return this.fProblemSeverity == 1 || this.fProblemSeverity == 2;
    }

    @Override
    public boolean isWarningNode() {
        return this.fProblemSeverity == 0;
    }

    @Override
    public void setProblemSeverity(int severity) {
        this.fProblemSeverity = severity;
    }

    @Override
    public boolean isExternal() {
        return this.fIsExternal;
    }

    public void setExternal(boolean isExternal) {
        this.fIsExternal = isExternal;
    }

    @Override
    public String getElementPath() {
        if (this.fElementPath == null) {
            StringBuilder buffer = new StringBuilder();
            String buildFileName = this.getProjectNode().getBuildFileName();
            if (buildFileName != null) {
                buffer.append(buildFileName);
            }
            buffer.append(this.getParentNode() != null ? this.getParentNode().getElementPath() : "");
            buffer.append('/');
            buffer.append(this.getElementIdentifier());
            buffer.append('[');
            buffer.append(this.fIndex);
            buffer.append(']');
            this.fElementPath = buffer.toString();
        }
        return this.fElementPath;
    }

    private String getElementIdentifier() {
        if (this.fElementIdentifier == null) {
            StringBuffer buffer = this.escape(new StringBuffer(this.getName() != null ? this.getName() : ""), '\\', "$/[]\\");
            buffer.append('$');
            buffer.append(this.escape(new StringBuffer(this.getLabel() != null ? this.getLabel() : ""), '\\', "$/[]\\").toString());
            this.fElementIdentifier = buffer.toString();
        }
        return this.fElementIdentifier;
    }

    private StringBuffer escape(StringBuffer sb, char esc, String special) {
        int i = 0;
        while (i < sb.length()) {
            if (special.indexOf(sb.charAt(i)) >= 0) {
                sb.insert(i++, esc);
            }
            ++i;
        }
        return sb;
    }

    public boolean equals(Object o2) {
        AntElementNode o1 = this;
        if (o1 == o2) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o1 instanceof AntElementNode) && !(o2 instanceof AntElementNode)) {
            return o2.equals(o1);
        }
        if (!(o1 instanceof AntElementNode) || !(o2 instanceof AntElementNode)) {
            return false;
        }
        AntElementNode e1 = o1;
        AntElementNode e2 = (AntElementNode)o2;
        return e1.getElementPath().equals(e2.getElementPath());
    }

    public int hashCode() {
        return this.getElementPath().hashCode();
    }

    @Override
    public int getSelectionLength() {
        return this.fSelectionLength;
    }

    public void setSelectionLength(int selectionLength) {
        this.fSelectionLength = selectionLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AntElementNode getNode(int sourceOffset) {
        AntElementNode antElementNode = this;
        synchronized (antElementNode) {
            if (this.fChildNodes != null) {
                for (IAntElement node : this.fChildNodes) {
                    AntElementNode containingNode = node.getNode(sourceOffset);
                    if (containingNode == null) continue;
                    return containingNode;
                }
            }
        }
        if (this.fLength == -1 && this.fOffset <= sourceOffset && !this.isExternal()) {
            return this;
        }
        if (this.fOffset <= sourceOffset && sourceOffset <= this.fOffset + this.fLength - 2) {
            return this;
        }
        return null;
    }

    public Image getImage() {
        int flags = 0;
        if (this.isErrorNode()) {
            flags |= 1;
        } else if (this.isWarningNode()) {
            flags |= 4;
        }
        if (this.fImportNode != null || this.isExternal()) {
            flags |= 2;
        }
        ImageDescriptor base = this.getBaseImageDescriptor();
        return AntUIImages.getImage(new AntImageDescriptor(base, flags));
    }

    protected ImageDescriptor getBaseImageDescriptor() {
        return AntUIImages.getImageDescriptor("org.eclipse.ant.ui.html_tab_obj");
    }

    protected IAntModel getAntModel() {
        IAntElement parentNode = this.getParentNode();
        while (!(parentNode instanceof AntProjectNode)) {
            parentNode = parentNode.getParentNode();
        }
        if (parentNode instanceof AntProjectNode) {
            return ((AntProjectNode)parentNode).getAntModel();
        }
        return null;
    }

    @Override
    public void setProblem(IProblem problem) {
        this.fProblem = problem;
    }

    public IProblem getProblem() {
        return this.fProblem;
    }

    protected void appendEntityName(StringBuffer displayName) {
        String path = this.getFilePath();
        if (this.getImportNode() != null) {
            displayName.append(MessageFormat.format(AntModelMessages.AntElementNode_9, this.getImportNode().getLabel()));
        } else {
            String entityName = this.getAntModel().getEntityName(path);
            displayName.append(MessageFormat.format(AntModelMessages.AntElementNode_9, entityName));
        }
    }

    @Override
    public AntElementNode getImportNode() {
        return this.fImportNode;
    }

    public void setImportNode(AntElementNode importNode) {
        this.fImportNode = importNode;
    }

    @Override
    public boolean hasChildren() {
        if (this.fChildNodes == null) {
            return false;
        }
        return !this.fChildNodes.isEmpty();
    }

    public void reset() {
        this.fChildNodes = null;
    }

    public void setExternalInfo(int line, int column) {
        this.fLine = line;
        this.fColumn = column;
    }

    public int[] getExternalInfo() {
        return new int[]{this.fLine, this.fColumn};
    }

    public IFile getIFile() {
        if (this.isExternal()) {
            return AntUtil.getFileForLocation(this.fFilePath, null);
        }
        return this.getBuildFileResource();
    }

    public IFile getBuildFileResource() {
        LocationProvider locationProvider = this.getAntModel().getLocationProvider();
        return locationProvider.getFile();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isStructuralNode() {
        return true;
    }

    @Override
    public boolean collapseProjection() {
        return false;
    }

    public void dispose() {
        this.getAntModel().dispose();
    }

    public String getReferencedElement(int offset) {
        return null;
    }

    @Override
    public String getProblemMessage() {
        return this.fProblemMessage;
    }

    @Override
    public void setProblemMessage(String problemMessage) {
        this.fProblemMessage = problemMessage;
    }

    @Override
    public boolean containsOccurrence(String identifier) {
        return false;
    }

    public String getOccurrencesIdentifier() {
        return this.getLabel();
    }

    public boolean isRegionPotentialReference(IRegion region) {
        return region.getOffset() >= this.fOffset;
    }

    @Override
    public List<Integer> computeIdentifierOffsets(String identifier) {
        return null;
    }

    public boolean isFromDeclaration(IRegion region) {
        return false;
    }

    protected boolean checkReferenceRegion(IRegion region, String textToSearch, String attributeName) {
        int attributeOffset = textToSearch.indexOf(attributeName);
        while (attributeOffset > 0 && !Character.isWhitespace(textToSearch.charAt(attributeOffset - 1))) {
            attributeOffset = textToSearch.indexOf(attributeName, attributeOffset + 1);
        }
        if (attributeOffset != -1) {
            int attributeOffsetEnd = textToSearch.indexOf(34, attributeOffset += attributeName.length());
            attributeOffsetEnd = textToSearch.indexOf(34, attributeOffsetEnd + 1);
            return region.getOffset() >= this.getOffset() + attributeOffset && region.getOffset() + region.getLength() <= this.getOffset() + attributeOffsetEnd;
        }
        return false;
    }
}

