/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;

final class Case
extends TemplateElement {
    final int TYPE_CASE = 0;
    final int TYPE_DEFAULT = 1;
    Expression condition;

    Case(Expression matchingValue, TemplateElement nestedBlock) {
        this.condition = matchingValue;
        this.nestedBlock = nestedBlock;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visitByHiddingParent(this.nestedBlock);
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        if (this.condition != null) {
            sb.append(' ');
            sb.append(this.condition.getCanonicalForm());
        }
        if (canonical) {
            sb.append('>');
            if (this.nestedBlock != null) {
                sb.append(this.nestedBlock.getCanonicalForm());
            }
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return this.condition != null ? "#case" : "#default";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.condition;
            }
            case 1: {
                return new Integer(this.condition != null ? 0 : 1);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.CONDITION;
            }
            case 1: {
                return ParameterRole.AST_NODE_SUBTYPE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

