/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolModelParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeConditionBoolValue;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonSubtypeConditionCustom;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonValueCondition;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.JavaCodeGenerator;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.QuickParser;

abstract class FieldConditionLogic {
    private final boolean logicRequiresQuickParser;

    FieldConditionLogic(boolean logicRequiresQuickParser) {
        this.logicRequiresQuickParser = logicRequiresQuickParser;
    }

    boolean requiresQuickParser() {
        return this.logicRequiresQuickParser;
    }

    abstract boolean checkValue(boolean var1, Object var2, QuickParser<?> var3) throws JsonProtocolParseException;

    static FieldConditionLogic readLogic(Method m) throws JsonProtocolModelParseException {
        JsonSubtypeCondition conditionAnn;
        JsonSubtypeConditionCustom customAnn;
        ArrayList<FieldConditionLogic> results = new ArrayList<FieldConditionLogic>(1);
        JsonSubtypeConditionBoolValue boolValueAnn = m.getAnnotation(JsonSubtypeConditionBoolValue.class);
        if (boolValueAnn != null) {
            final Boolean required = boolValueAnn.value();
            results.add(new FieldConditionLogic(true){

                @Override
                boolean checkValue(boolean hasValue, Object unparsedValue, QuickParser<?> parser) throws JsonProtocolParseException {
                    return hasValue && required == parser.parseValueQuick(unparsedValue);
                }

                @Override
                void writeCheckJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef, String resultRef, QuickParser<?> quickParser) {
                    scope.startLine("boolean " + resultRef + ";\n");
                    scope.startLine("if (" + hasValueRef + ") {\n");
                    scope.indentRight();
                    quickParser.writeParseQuickCode(scope, valueRef, "parserResult");
                    scope.startLine(String.valueOf(resultRef) + " = " + required + " == parserResult;\n");
                    scope.indentLeft();
                    scope.startLine("} else {\n");
                    scope.startLine("  " + resultRef + " = false;\n");
                    scope.startLine("}\n");
                }
            });
        }
        if ((customAnn = m.getAnnotation(JsonSubtypeConditionCustom.class)) != null) {
            customAnn.condition();
            Class<? extends JsonValueCondition<?>> assumedTypeCondition = customAnn.condition();
            final CustomConditionWrapper constraint = CustomConditionWrapper.create(assumedTypeCondition);
            results.add(new FieldConditionLogic(true){

                @Override
                boolean checkValue(boolean hasValue, Object unparsedValue, QuickParser<?> parser) throws JsonProtocolParseException {
                    return hasValue && constraint.checkValue(parser.parseValueQuick(unparsedValue));
                }

                @Override
                void writeCheckJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef, String resultRef, QuickParser<?> quickParser) {
                    scope.startLine("boolean " + resultRef + ";\n");
                    scope.startLine("if (" + hasValueRef + ") {\n");
                    scope.indentRight();
                    quickParser.writeParseQuickCode(scope, valueRef, "parserResult");
                    constraint.writeParseJava(scope, "parserResult", "constraintResult");
                    scope.startLine(String.valueOf(resultRef) + " = constraintResult;\n");
                    scope.indentLeft();
                    scope.startLine("} else {\n");
                    scope.startLine("  " + resultRef + " = false;\n");
                    scope.startLine("}\n");
                }
            });
        }
        if ((conditionAnn = m.getAnnotation(JsonSubtypeCondition.class)) != null) {
            int savedResSize = results.size();
            if (conditionAnn.fieldIsAbsent()) {
                results.add(new FieldConditionLogic(false){

                    @Override
                    boolean checkValue(boolean hasValue, Object unparsedValue, QuickParser<?> parser) {
                        return !hasValue;
                    }

                    @Override
                    void writeCheckJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef, String resultRef, QuickParser<?> quickParser) {
                        scope.startLine("boolean " + resultRef + " = !" + hasValueRef + ";\n");
                    }
                });
            }
            if (conditionAnn.valueIsNull()) {
                results.add(new FieldConditionLogic(false){

                    @Override
                    boolean checkValue(boolean hasValue, Object unparsedValue, QuickParser<?> parser) {
                        return hasValue && unparsedValue != null;
                    }

                    @Override
                    void writeCheckJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef, String resultRef, QuickParser<?> quickParser) {
                        scope.startLine("boolean " + resultRef + " = " + valueRef + " != null;\n");
                    }
                });
            }
            if (savedResSize == results.size()) {
                results.add(new FieldConditionLogic(false){

                    @Override
                    boolean checkValue(boolean hasValue, Object unparsedValue, QuickParser<?> parser) {
                        return hasValue;
                    }

                    @Override
                    void writeCheckJava(JavaCodeGenerator.MethodScope scope, String valueRef, String hasValueRef, String resultRef, QuickParser<?> quickParser) {
                        scope.startLine("boolean " + resultRef + " = " + hasValueRef + ";\n");
                    }
                });
            }
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() > 1) {
            throw new JsonProtocolModelParseException("Too many constraints for field getter " + m);
        }
        return (FieldConditionLogic)results.get(0);
    }

    abstract void writeCheckJava(JavaCodeGenerator.MethodScope var1, String var2, String var3, String var4, QuickParser<?> var5);

    private static class CustomConditionWrapper<T> {
        private final JsonValueCondition<? super T> constraint;

        static <T> CustomConditionWrapper<T> create(Class<? extends JsonValueCondition<T>> constraintClass) {
            return new CustomConditionWrapper<T>(constraintClass);
        }

        private CustomConditionWrapper(Class<? extends JsonValueCondition<? super T>> constraintClass) {
            try {
                this.constraint = constraintClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        boolean checkValue(Object parsedValue) {
            return this.constraint.conforms(parsedValue);
        }

        public void writeParseJava(JavaCodeGenerator.ClassScope classScope, String valueRef, String resultRef) {
            abstract class StaticField
            implements JavaCodeGenerator.ElementData {
                StaticField() {
                }

                abstract String getFieldName();
            }
            StaticField field = classScope.getRootClassScope().addMember(this.constraint.getClass(), new JavaCodeGenerator.ElementFactory<StaticField>(){

                @Override
                public StaticField create(final int code) {
                    return new StaticField(CustomConditionWrapper.this){
                        {
                        }

                        @Override
                        public void generateCode(JavaCodeGenerator.ClassScope classScope) {
                            classScope.startLine("private static final " + CustomConditionWrapper.this.constraint.getClass().getCanonicalName() + " " + this.getFieldName() + " = new " + CustomConditionWrapper.this.constraint.getClass().getCanonicalName() + "();\n");
                        }

                        @Override
                        String getFieldName() {
                            return "CUSTOM_CONDITION_" + code;
                        }
                    };
                }
            });
            classScope.startLine("boolean " + resultRef + " = " + field.getFieldName() + ".conforms(" + valueRef + ");\n");
        }
    }
}

