(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../utils/arrUtils", "../parser/yamlParser07", "vscode-json-languageservice/lib/umd/services/jsonHover", "../parser/isKubernetes"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Red Hat, Inc. All rights reserved.
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    const arrUtils_1 = require("../utils/arrUtils");
    const yamlParser07_1 = require("../parser/yamlParser07");
    const jsonHover_1 = require("vscode-json-languageservice/lib/umd/services/jsonHover");
    const isKubernetes_1 = require("../parser/isKubernetes");
    class YAMLHover {
        constructor(schemaService) {
            this.shouldHover = true;
            this.jsonHover = new jsonHover_1.JSONHover(schemaService, [], Promise);
        }
        configure(languageSettings) {
            if (languageSettings) {
                this.shouldHover = languageSettings.hover;
            }
        }
        doHover(document, position, isKubernetes = false) {
            if (!this.shouldHover || !document) {
                return Promise.resolve(undefined);
            }
            const doc = yamlParser07_1.parse(document.getText());
            const offset = document.offsetAt(position);
            const currentDoc = arrUtils_1.matchOffsetToDocument(offset, doc);
            if (currentDoc === null) {
                return Promise.resolve(undefined);
            }
            isKubernetes_1.setKubernetesParserOption(doc.documents, isKubernetes);
            const currentDocIndex = doc.documents.indexOf(currentDoc);
            currentDoc.currentDocIndex = currentDocIndex;
            return this.jsonHover.doHover(document, position, currentDoc);
        }
    }
    exports.YAMLHover = YAMLHover;
});
//# sourceMappingURL=yamlHover.js.map