import RAL from './ral';
import { Event } from './events';
import { Message } from './messages';
import { ContentDecoder, ContentTypeDecoder } from './encoding';
import { Disposable } from './api';
export interface DataCallback {
    (data: Message): void;
}
export interface PartialMessageInfo {
    readonly messageToken: number;
    readonly waitingTime: number;
}
export interface MessageReader {
    readonly onError: Event<Error>;
    readonly onClose: Event<void>;
    readonly onPartialMessage: Event<PartialMessageInfo>;
    listen(callback: DataCallback): Disposable;
    dispose(): void;
}
export declare namespace MessageReader {
    function is(value: any): value is MessageReader;
}
export declare abstract class AbstractMessageReader implements MessageReader {
    private errorEmitter;
    private closeEmitter;
    private partialMessageEmitter;
    constructor();
    dispose(): void;
    get onError(): Event<Error>;
    protected fireError(error: any): void;
    get onClose(): Event<void>;
    protected fireClose(): void;
    get onPartialMessage(): Event<PartialMessageInfo>;
    protected firePartialMessage(info: PartialMessageInfo): void;
    private asError;
    abstract listen(callback: DataCallback): Disposable;
}
export interface MessageReaderOptions {
    charset?: RAL.MessageBufferEncoding;
    contentDecoder?: ContentDecoder;
    contentDecoders?: ContentDecoder[];
    contentTypeDecoder?: ContentTypeDecoder;
    contentTypeDecoders?: ContentTypeDecoder[];
}
export declare class ReadableStreamMessageReader extends AbstractMessageReader {
    private readable;
    private options;
    private callback;
    private nextMessageLength;
    private messageToken;
    private buffer;
    private partialMessageTimer;
    private _partialMessageTimeout;
    constructor(readable: RAL.ReadableStream, options?: RAL.MessageBufferEncoding | MessageReaderOptions);
    set partialMessageTimeout(timeout: number);
    get partialMessageTimeout(): number;
    listen(callback: DataCallback): Disposable;
    private onData;
    private clearPartialMessageTimer;
    private setPartialMessageTimer;
}
