/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.DesignerPlugin;

public class FlagImagesRepository {
    private static Map<String, Image> m_countriesFlags = Maps.newHashMap();
    private static Locale[] m_locales;

    private static void init() {
        if (m_locales == null) {
            ArrayList locales = Lists.newArrayList();
            Collections.addAll(locales, Locale.getAvailableLocales());
            Collections.sort(locales, new Comparator<Locale>(){

                @Override
                public int compare(Locale o1, Locale o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            m_locales = locales.toArray(new Locale[locales.size()]);
        }
    }

    public static Locale[] getSortedLocales() {
        FlagImagesRepository.init();
        return m_locales;
    }

    public static Image getEmptyFlagImage() {
        return DesignerPlugin.getImage((String)"nls/flags/flag_empty.png");
    }

    public static Image getFlagImage(Locale locale) {
        Image flagImage;
        FlagImagesRepository.init();
        String localeCountry = locale.getCountry();
        String localeLanguage = locale.getLanguage();
        if (localeCountry.length() == 0) {
            if (localeLanguage.equals("ar")) {
                localeCountry = "AE";
            } else if (localeLanguage.equals("zh")) {
                localeCountry = "CN";
            } else if (localeLanguage.equals("en")) {
                localeCountry = "US";
            } else {
                String localeCountryCandidate = "";
                int i = 0;
                while (i < m_locales.length) {
                    Locale lookupLocale = m_locales[i];
                    String lookupLanguage = lookupLocale.getLanguage();
                    if (lookupLanguage.equals(localeLanguage) && lookupLocale.getCountry().length() != 0 && (localeCountryCandidate = lookupLocale.getCountry()).equalsIgnoreCase(lookupLanguage)) {
                        localeCountry = localeCountryCandidate;
                        break;
                    }
                    ++i;
                }
                if (localeCountry.length() == 0) {
                    localeCountry = localeCountryCandidate;
                }
            }
        }
        if ((flagImage = m_countriesFlags.get(localeCountry)) == null) {
            try {
                String flagFileName = null;
                if (localeCountry.equalsIgnoreCase("YU")) {
                    localeCountry = "CS";
                }
                if (StringUtils.isEmpty((String)localeCountry)) {
                }
                flagFileName = String.valueOf(localeCountry.toLowerCase()) + ".png";
                flagImage = DesignerPlugin.getImage((String)("nls/flags/" + flagFileName));
                m_countriesFlags.put(localeCountry, flagImage);
            }
            finally {
                return null;
            }
        }
        return flagImage;
    }
}

