/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiset;

public class EMFDataSource
implements IGraphDataSource<EObject> {
    private List<IGraphObserver<EObject>> observers;
    private Set<EReference> references;
    private Set<EClass> classes;
    private NavigationHelper navigationHelper;
    private IMultiset<EObject> allEObjects;

    public EMFDataSource(NavigationHelper navigationHelper, Set<EReference> references, Set<EClass> classes) {
        this.references = references;
        this.classes = classes;
        this.observers = new LinkedList<IGraphObserver<EObject>>();
        this.navigationHelper = navigationHelper;
    }

    public Set<EObject> getAllNodes() {
        return this.getAllEObjects().distinctValues();
    }

    public IMemoryView<EObject> getTargetNodes(EObject source) {
        IMultiset targetNodes = CollectionsFactory.createMultiset();
        for (EReference ref : this.references) {
            Set<EObject> referenceValues = this.navigationHelper.getReferenceValues(source, ref);
            for (EObject referenceValue : referenceValues) {
                targetNodes.addOne((Object)referenceValue);
            }
        }
        return targetNodes;
    }

    public void attachObserver(IGraphObserver<EObject> go) {
        this.observers.add(go);
    }

    public void attachAsFirstObserver(IGraphObserver<EObject> observer) {
        this.observers.add(0, observer);
    }

    public void detachObserver(IGraphObserver<EObject> go) {
        this.observers.remove(go);
    }

    public void notifyEdgeInserted(EObject source, EObject target) {
        this.nodeAdditionInternal(source);
        this.nodeAdditionInternal(target);
        for (IGraphObserver<EObject> o : this.observers) {
            o.edgeInserted((Object)source, (Object)target);
        }
    }

    public void notifyEdgeDeleted(EObject source, EObject target) {
        for (IGraphObserver<EObject> o : this.observers) {
            o.edgeDeleted((Object)source, (Object)target);
        }
        this.nodeRemovalInternal(source);
        this.nodeRemovalInternal(target);
    }

    public void notifyNodeInserted(EObject node) {
        this.nodeAdditionInternal(node);
    }

    public void notifyNodeDeleted(EObject node) {
        this.nodeRemovalInternal(node);
    }

    private void nodeAdditionInternal(EObject node) {
        if (this.allEObjects.addOne((Object)node)) {
            for (IGraphObserver<EObject> o : this.observers) {
                o.nodeInserted((Object)node);
            }
        }
    }

    private void nodeRemovalInternal(EObject node) {
        if (this.getAllEObjects().removeOne((Object)node)) {
            for (IGraphObserver<EObject> o : this.observers) {
                o.nodeDeleted((Object)node);
            }
        }
    }

    protected IMultiset<EObject> getAllEObjects() {
        if (this.allEObjects == null) {
            this.allEObjects = CollectionsFactory.createMultiset();
            for (EClass clazz : this.classes) {
                for (EObject obj : this.navigationHelper.getAllInstances(clazz)) {
                    this.allEObjects.addOne((Object)obj);
                }
            }
            for (EReference ref : this.references) {
                this.navigationHelper.processAllFeatureInstances((EStructuralFeature)ref, (source, target) -> {
                    this.allEObjects.addOne((Object)source);
                    this.allEObjects.addOne((Object)((EObject)target));
                });
            }
        }
        return this.allEObjects;
    }
}

