/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.chart.ui.data;

import java.math.BigDecimal;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class ChartRange {
    private BigDecimal fMinimum;
    private BigDecimal fMaximum;
    private BigDecimal fRange;

    public ChartRange() {
        this.fMinimum = BigDecimal.ZERO;
        this.fMaximum = BigDecimal.ONE;
        this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)this.getMaximum().subtract(this.getMinimum()));
    }

    public ChartRange(BigDecimal minimum, BigDecimal maximum) {
        BigDecimal subtract = maximum.subtract(minimum);
        if (minimum.compareTo(maximum) > 0) {
            throw new IllegalArgumentException("ChartRange: minimum should be lower than or equal to the maximum (min: " + minimum + ", max: " + maximum + ')');
        }
        if (BigDecimal.ZERO.equals(subtract)) {
            this.fMinimum = minimum;
            this.fMaximum = minimum.add(BigDecimal.ONE);
            this.fRange = BigDecimal.ONE;
        } else {
            this.fMinimum = minimum;
            this.fMaximum = maximum;
            this.fRange = (BigDecimal)NonNullUtils.checkNotNull((Object)subtract);
        }
    }

    public BigDecimal getMinimum() {
        return this.fMinimum;
    }

    public BigDecimal getMaximum() {
        return this.fMaximum;
    }

    public BigDecimal getDelta() {
        return this.fRange;
    }

    public ChartRange clamp() {
        if (this.fMinimum.compareTo(BigDecimal.ZERO) > 0) {
            this.fMinimum = BigDecimal.ZERO;
            this.fRange = this.fMaximum;
        }
        return this;
    }

    public String toString() {
        return "ChartRange: [" + this.fMinimum + ", " + this.fMaximum + "]";
    }
}

